/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.authentication;

import com.google.common.base.Preconditions;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class XltestLicenseCheckFilter
implements Filter {
    private static final String BOOTSTRAP_LICENSE_LICENSEE = "Installation Bootstrap License";
    private static final Logger log = LoggerFactory.getLogger(XltestLicenseCheckFilter.class);
    private LicenseService licenseService;

    public void init(FilterConfig filterConfig) throws ServletException {
        log.trace("Added LicenseCheckFilter to the mix.");
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        Preconditions.checkNotNull((Object)ctx, (Object)"LicenseCheckFilter: Could not find web application context");
        this.licenseService = (LicenseService)ctx.getBean(LicenseService.class);
        Preconditions.checkNotNull((Object)this.licenseService, (Object)"LicenseCheckFilter: Could not find license check service");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        License license = this.licenseService.getLicense();
        if (this.isBootstrapLicense(license) || !this.licenseIsValid() && response instanceof HttpServletResponse) {
            log.debug("This license is invalid: {}", (Object)license);
            HttpServletResponse hsr = (HttpServletResponse)response;
            hsr.sendError(402, "License expired");
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isBootstrapLicense(License license) {
        return license.getStringValue(LicenseProperty.LICENSED_TO).equals(BOOTSTRAP_LICENSE_LICENSEE);
    }

    private boolean licenseIsValid() {
        try {
            this.licenseService.validate();
        }
        catch (Exception e) {
            log.debug("Invalid license:", (Throwable)e);
            return false;
        }
        return true;
    }

    public void destroy() {
    }
}

