/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.repository;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestRunImpl;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.service.EventRepository;
import com.xebialabs.xltest.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class TestRunsRepositoryImpl
implements TestRunsRepository {
    private static Logger LOG = LoggerFactory.getLogger(TestRunsRepositoryImpl.class);
    private final EventRepository eventRepository;
    private static final Comparator<TestRun> startTimeComparator = new Comparator<TestRun>(){

        @Override
        public int compare(TestRun r1, TestRun r2) {
            return r1.getStartTime().compareTo(r2.getStartTime());
        }
    };

    @Autowired
    public TestRunsRepositoryImpl(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public TestRun getTestRun(String testRunId) {
        return this.getTestRun(UUID.fromString(testRunId));
    }

    public TestRun getTestRun(UUID testRunId) {
        List<Event> events = this.getEventsForRunId(testRunId, Collections.emptyMap());
        return new TestRunImpl(events);
    }

    private String constructQuery(long startTime, long endTime, Map queryParameters) {
        return TestRunsRepositoryImpl.constructSearchQuery("timestamp:>=" + startTime + " AND timestamp:<=" + endTime, queryParameters);
    }

    public static String constructSearchQuery(String query, Map queryParameters) {
        StringBuilder queryBuilder = new StringBuilder(query);
        for (Object key : queryParameters.keySet()) {
            if (queryParameters.get(key) instanceof String) {
                String value = (String)queryParameters.get(key);
                if (!StringUtils.hasText((String)value)) continue;
                queryBuilder.append(" AND " + key + ":\"" + value + "\"");
                continue;
            }
            if (!(queryParameters.get(key) instanceof Collection)) continue;
            queryBuilder.append(" AND " + key + ":");
            Collection collection = (Collection)queryParameters.get(key);
            queryBuilder.append(Joiner.on((String)" AND ").join((Iterable)collection));
        }
        LOG.debug("constructSearchQuery(): {}", (Object)queryBuilder);
        return queryBuilder.toString();
    }

    private List<Event> getEventsBetweenByType(long startTime, long endTime, String eventType, Map<String, String> queryParameters) {
        HashMap<String, String> startTestRunQuery = new HashMap<String, String>(queryParameters);
        startTestRunQuery.put("type", eventType);
        String query = this.constructQuery(startTime, endTime, startTestRunQuery);
        LOG.info("Querying ES with: {} for events in a timerange filtered by query params", (Object)query);
        return this.eventRepository.query(query);
    }

    public Event getLatestEventOfType(String testSpecification, String eventType, long fromDate, long endDate) {
        HashMap<String, String> latestEventsQuery = new HashMap<String, String>();
        latestEventsQuery.put("type", eventType);
        latestEventsQuery.put("testSpecification", testSpecification);
        String query = this.constructQuery(fromDate, endDate, latestEventsQuery);
        return this.eventRepository.fetchLatest(query);
    }

    public Event getLatestEventOfTypeAndRunId(String testSpecification, String eventType, UUID runId, long fromDate, long endDate) {
        HashMap<String, String> latestEventsQuery = new HashMap<String, String>();
        latestEventsQuery.put("type", eventType);
        latestEventsQuery.put("testSpecification", testSpecification);
        latestEventsQuery.put("runId", runId.toString());
        String query = this.constructQuery(fromDate, endDate, latestEventsQuery);
        return this.eventRepository.fetchLatest(query);
    }

    @Deprecated
    private List<TestRun> getTestRuns(Map queryParameters) {
        int startTime = 0;
        long endTime = System.currentTimeMillis();
        return this.getTestRuns(queryParameters, startTime, endTime);
    }

    public TestRun getLatestTestRun(String testSpecification, long fromDate) {
        return this.getLatestTestRun(testSpecification, fromDate, System.currentTimeMillis());
    }

    public TestRun getLatestTestRun(String testSpecification, long fromDate, long endDate) {
        LOG.debug("getLatestTestRun: testSpecification={} from={} to={}", new Object[]{testSpecification, fromDate, endDate});
        Event executionStartedEvent = this.getLatestEventOfType(testSpecification, "executionStarted", fromDate, endDate);
        Event importStartedEvent = this.getLatestEventOfType(testSpecification, "importStarted", fromDate, endDate);
        if (executionStartedEvent != null && (importStartedEvent == null || executionStartedEvent.getTimestamp() > importStartedEvent.getTimestamp())) {
            return this.getTestRun(executionStartedEvent.getTestRunId());
        }
        if (importStartedEvent != null) {
            return this.getTestRun(importStartedEvent.getTestRunId());
        }
        return null;
    }

    public List<TestRun> getTestRunsBetween(String testSpecificationName, long startTime, long endTime) {
        HashMap<String, String> eventsByTestSpecification = new HashMap<String, String>();
        eventsByTestSpecification.put("testSpecification", testSpecificationName);
        return this.getTestRuns(eventsByTestSpecification, Math.min(startTime, endTime), Math.max(startTime, endTime));
    }

    public List<TestRun> getTestRuns(Map queryParameters, long startTime, long endTime) {
        List<Event> allStartEventsAsList = this.getEventsBetweenByType(startTime, endTime, "executionStarted", queryParameters);
        Map<UUID, Event> startEvents = this.getAllEventsAsMap(allStartEventsAsList);
        List<Event> allImportStartedEvents = this.getEventsBetweenByType(startTime, endTime, "importStarted", queryParameters);
        Map<UUID, Event> importStartedEvents = this.getAllEventsAsMap(allImportStartedEvents);
        Set<UUID> allUuids = this.getAllUuids(startEvents, importStartedEvents);
        ArrayList<TestRun> testRuns = new ArrayList<TestRun>();
        for (UUID uuid : allUuids) {
            testRuns.add(this.getTestRun(uuid));
        }
        Collections.sort(testRuns, new Comparator<TestRun>(){

            @Override
            public int compare(TestRun o1, TestRun o2) {
                Date startTime1 = o1.getStartTime() != null ? o1.getStartTime() : new Date(0L);
                Date startTime2 = o2.getStartTime() != null ? o2.getStartTime() : new Date(0L);
                return startTime2.compareTo(startTime1);
            }
        });
        return testRuns;
    }

    private Set<UUID> getAllUuids(Map<UUID, Event> startEvents, Map<UUID, Event> importStartedEvents) {
        HashSet<UUID> allUuids = new HashSet<UUID>();
        allUuids.addAll(startEvents.keySet());
        allUuids.addAll(importStartedEvents.keySet());
        return allUuids;
    }

    private Map<UUID, Event> getAllEventsAsMap(List<Event> events) {
        HashMap<UUID, Event> map = new HashMap<UUID, Event>();
        for (Event ev : events) {
            map.put(ev.getTestRunId(), ev);
        }
        return map;
    }

    public List<TestRun> getPreviousRuns(TestRun testRun, int max) {
        return this.getSimilarRunsSortedInTime(testRun.getTestSpecificationName(), testRun.getStartTime(), max, this.getReverseComparator(), true);
    }

    public List<TestRun> getPreviousRuns(String testSpecificationName, int max) {
        return this.getSimilarRunsSortedInTime(testSpecificationName, new Date(), max, this.getReverseComparator(), true);
    }

    public List<TestRun> getLaterRuns(TestRun testRun, int max) {
        return this.getSimilarRunsSortedInTime(testRun.getTestSpecificationName(), testRun.getStartTime(), max, startTimeComparator, false);
    }

    public List<Event> getEventsBetween(long startTime, long endTime, Map<String, Object> eventProperties) {
        String query = this.constructQuery(startTime, endTime, eventProperties);
        return this.eventRepository.query(query);
    }

    public List<Event> getResultEventsThatChangedFromLastRun(TestRun testRun) {
        List<TestRun> testRuns = this.getPreviousRuns(testRun, 2);
        if (testRuns.size() == 0) {
            return Lists.newArrayList();
        }
        TestRun oldTestRun = testRuns.get(1);
        Predicate<Event> containingNameAndResult = new Predicate<Event>(){

            public boolean apply(Event event) {
                return event.hasProperty("name") && event.hasProperty("result");
            }
        };
        Function<Event, String> eventIndexFn = new Function<Event, String>(){

            public String apply(Event event) {
                return (String)event.get("name");
            }
        };
        Collection events = Collections2.filter((Collection)testRun.getEvents(), (Predicate)containingNameAndResult);
        Collection oldEvents = Collections2.filter((Collection)oldTestRun.getEvents(), (Predicate)containingNameAndResult);
        ImmutableMap events_map = Maps.uniqueIndex((Iterable)events, (Function)eventIndexFn);
        ImmutableMap oldEvents_map = Maps.uniqueIndex((Iterable)oldEvents, (Function)eventIndexFn);
        ArrayList<Event> deltaEvents = new ArrayList<Event>(100);
        for (Event ev : events_map.values()) {
            String name = (String)ev.get("name");
            if (!oldEvents_map.containsKey(name) || ev.get("result").equals(((Event)oldEvents_map.get(name)).get("result"))) continue;
            deltaEvents.add(ev);
        }
        return deltaEvents;
    }

    public void refreshIndex() {
        this.eventRepository.refreshIndex();
    }

    @Deprecated
    public List<Event> getEventsForRunId(UUID testRunId, Map<String, Object> eventProperties) {
        Preconditions.checkNotNull(eventProperties);
        HashMap<String, Object> queryParams = new HashMap<String, Object>(eventProperties);
        queryParams.put("runId", testRunId.toString());
        String query = this.constructQuery(0L, System.currentTimeMillis(), queryParams);
        return this.eventRepository.query(query);
    }

    @Deprecated
    public List<Event> getEventsForRunIdWithPrefix(UUID testRunId, String prefix, Map<String, Object> eventProperties) {
        LOG.debug("Returning events with prefix {}", (Object)prefix);
        List<Event> events = this.getEventsForRunId(testRunId, eventProperties);
        if (prefix.isEmpty()) {
            return events;
        }
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event ev : events) {
            if (!ev.hasProperty("name") || !ev.get("name").toString().startsWith(prefix)) continue;
            result.add(ev);
        }
        return result;
    }

    private List<TestRun> getSimilarRunsSortedInTime(String testSpecificationName, final Date fromDate, int max, Comparator<TestRun> comparator, final boolean before) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("testSpecification", testSpecificationName);
        List<TestRun> allTestRuns = this.getTestRuns(queryParams);
        Collections.sort(allTestRuns, comparator);
        Collection filtered = Collections2.filter(allTestRuns, (Predicate)new Predicate<TestRun>(){

            public boolean apply(TestRun run) {
                return TestRunsRepositoryImpl.this.beforeOrAfter(fromDate, run, before);
            }
        });
        ImmutableList similarRunsSortedInTime = FluentIterable.from((Iterable)filtered).limit(max).toList();
        LOG.debug("I got {} similar runs", (Object)similarRunsSortedInTime.size());
        return similarRunsSortedInTime;
    }

    private boolean beforeOrAfter(Date startTime, TestRun testRun, boolean before) {
        if (before) {
            return testRun.getStartTime().before(startTime);
        }
        return testRun.getStartTime().after(startTime);
    }

    private Comparator<TestRun> getReverseComparator() {
        Comparator<TestRun> comparator = new Comparator<TestRun>(){

            @Override
            public int compare(TestRun r1, TestRun r2) {
                return r2.getStartTime().compareTo(r1.getStartTime());
            }
        };
        return comparator;
    }

    @Deprecated
    public List<Event> getCorrespondingEventsFromOlderRuns(TestRun testRun, Event event, int max, String ... matchingProperties) {
        ArrayList<Event> events = new ArrayList<Event>();
        List<TestRun> previousRuns = this.getPreviousRuns(testRun, max);
        LOG.debug("While getting events from max " + max + " previous Runs, I got " + previousRuns.size() + " such runs");
        Map queryParameters = this.makeQueryParameters(event, matchingProperties);
        for (TestRun previousRun : previousRuns) {
            List eventsOfPreviousRun = previousRun.getEvents(queryParameters);
            LOG.debug("Found " + eventsOfPreviousRun.size() + " events with matching properties in a previous run");
            events.addAll(eventsOfPreviousRun);
        }
        LOG.debug("Found " + events.size() + " CorrespondingEventsFromOlderRuns.");
        return events;
    }

    private Map makeQueryParameters(Event event, String ... matchingProperties) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        if (matchingProperties != null && matchingProperties.length != 0) {
            for (String propertyKey : matchingProperties) {
                queryParameters.put(propertyKey, event.get(propertyKey));
            }
        }
        return queryParameters;
    }

    public Event getLatestEventWithProperties(Map<String, String> query) {
        AndFilterBuilder builder = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
        builder.add((FilterBuilder)FilterBuilders.typeFilter((String)"qualificationComputed"));
        for (Map.Entry<String, String> property : query.entrySet()) {
            builder.add((FilterBuilder)FilterBuilders.termFilter((String)property.getKey(), (String)property.getValue()));
        }
        FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)builder);
        return this.eventRepository.fetchLatestGroupBy((QueryBuilder)qb);
    }

    @Deprecated
    public List<Event> getCorrespondingEventsFromOtherRuns(Event event, List<TestRun> otherRuns, String ... matchingProperties) {
        ArrayList<Event> events = new ArrayList<Event>();
        Map queryParameters = this.makeQueryParameters(event, matchingProperties);
        for (TestRun previousRun : otherRuns) {
            List eventsOfPreviousRun = previousRun.getEvents(queryParameters);
            LOG.debug("Found " + eventsOfPreviousRun.size() + " events with matching properties in a previous run");
            events.addAll(eventsOfPreviousRun);
        }
        LOG.debug("Found " + events.size() + " CorrespondingEventsFromOlderRuns");
        return events;
    }

    @Deprecated
    public Map<String, List<Event>> getEventsFromRunsAsMapGroupedBy(String mapProperty, List<TestRun> runs, String ... matchingKVs) {
        Map<String, Object> properties = this.makeEventProperties(matchingKVs);
        Set<String> keySet = properties.keySet();
        String[] matchingProperties = keySet.toArray(new String[keySet.size()]);
        Event event = new Event(properties);
        List<Event> allEvents = this.getCorrespondingEventsFromOtherRuns(event, runs, matchingProperties);
        HashMap<String, List<Event>> map = new HashMap<String, List<Event>>();
        for (Event e : allEvents) {
            String groupByValue = (String)e.get(mapProperty);
            if (map.get(groupByValue) == null) {
                map.put(groupByValue, new ArrayList());
            }
            ((List)map.get(groupByValue)).add(e);
        }
        return this.orderEventsByTimeStampNewestOnTop(map);
    }

    @Deprecated
    public Map<String, List<Event>> getEventsFromRunsAsMapGroupedBy(String mapProperty, int level, List<TestRun> runs, String ... matchingKVs) {
        Map<String, Object> properties = this.makeEventProperties(matchingKVs);
        Set<String> keySet = properties.keySet();
        String[] matchingProperties = keySet.toArray(new String[keySet.size()]);
        Event event = new Event(properties);
        List<Event> allEvents = this.getCorrespondingEventsFromOtherRuns(event, runs, matchingProperties);
        HashMap<String, List<Event>> map = new HashMap<String, List<Event>>();
        for (Event e : allEvents) {
            String groupByValue = this.cutAtLevel((String)e.get(mapProperty), level);
            if (map.get(groupByValue) == null) {
                map.put(groupByValue, new ArrayList());
            }
            ((List)map.get(groupByValue)).add(e);
        }
        return this.orderEventsByTimeStampNewestOnTop(map);
    }

    @Deprecated
    private Map<String, List<Event>> orderEventsByTimeStampNewestOnTop(Map<String, List<Event>> map) {
        for (List<Event> events : map.values()) {
            Collections.sort(events, new Comparator<Event>(){

                @Override
                public int compare(Event r1, Event r2) {
                    Comparable t1 = null;
                    Comparable t2 = null;
                    try {
                        t1 = (Comparable)r1.get("timestamp");
                        t2 = (Comparable)r2.get("timestamp");
                        return t1.compareTo(t2);
                    }
                    catch (Exception e) {
                        LOG.error("t1: {} can't be compared to {}. t1 class: {}", (Object)t1, t2);
                        return 0;
                    }
                }
            });
        }
        return map;
    }

    @Deprecated
    private String cutAtLevel(String pageName, int level) {
        String[] parts = pageName.split(";");
        if (level > parts.length) {
            return pageName;
        }
        int index = 0;
        for (int i = 0; i < level; ++i) {
            index = index + parts[i].length() + 1;
        }
        String result = pageName.substring(0, index);
        if (result.endsWith(";")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @Deprecated
    private Map<String, Object> makeEventProperties(String[] matchingKVs) {
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        for (int i = 0; i < matchingKVs.length; ++i) {
            Pair p = this.parseKV(matchingKVs[i]);
            eventProperties.put(p.getKey(), p.getValue());
        }
        return eventProperties;
    }

    @Deprecated
    private Pair parseKV(String kv) {
        String key = kv.substring(0, kv.indexOf(58));
        String value = kv.substring(key.length() + 1);
        return new Pair(key, value);
    }
}

