/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.repository.ProjectRepository;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.serialize.ExecutionProgressEventWriter;
import com.xebialabs.xltest.service.ExecutionProgressEvent;
import com.xebialabs.xltest.service.TestExecutionStateHolder;
import java.io.PrintWriter;
import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestSpecificationStatusStream {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecificationStatusStream.class);
    private final ProjectRepository projectRepository;
    private final TestSpecificationRepository testSpecificationRepository;
    private final TestExecutionStateHolder testExecutionStateHolder;
    private final ExecutionProgressEventWriter serializer = new ExecutionProgressEventWriter();

    @Autowired
    public TestSpecificationStatusStream(ProjectRepository projectRepository, TestSpecificationRepository testSpecificationRepository, TestExecutionStateHolder testExecutionStateHolder) {
        this.projectRepository = projectRepository;
        this.testSpecificationRepository = testSpecificationRepository;
        this.testExecutionStateHolder = testExecutionStateHolder;
    }

    public void getSpecificationStatuses(String projectId, PrintWriter writer) throws Exception {
        List<BaseTestSpecification> testSpecifications = this.projectRepository.getTestSpecifications(projectId);
        List<ExecutionProgressEvent> progressEvents = this.testExecutionStateHolder.getProgress(testSpecifications);
        if (progressEvents.isEmpty()) {
            LOG.trace("No test specifications are running at the moment");
            this.sendEmptyEvent(writer);
        }
        for (ExecutionProgressEvent progressEvent : progressEvents) {
            try {
                this.sendEvent(progressEvent, writer);
            }
            catch (JSONException e) {
                LOG.debug("Exception while sending event:", (Throwable)e);
            }
        }
    }

    public void getSpecificationStatus(String testSpecificationId, PrintWriter writer) throws Exception {
        BaseTestSpecification testSpecification = this.testSpecificationRepository.get(testSpecificationId);
        ExecutionProgressEvent progressEvent = this.testExecutionStateHolder.getProgressEvent(testSpecification);
        if (progressEvent != null) {
            this.sendEvent(progressEvent, writer);
        } else {
            LOG.trace("No test is running at the moment");
            this.sendEmptyEvent(writer);
        }
    }

    private void sendEvent(ExecutionProgressEvent event, PrintWriter writer) throws JSONException {
        writer.write("event: event\n");
        writer.write("data: " + this.serializer.serialize(event) + "\n\n");
        writer.flush();
    }

    private void sendEmptyEvent(PrintWriter writer) {
        writer.write("event: event\n");
        writer.flush();
    }
}

