/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize.exceptionmappers;

import com.xebialabs.xltest.serialize.exceptionmappers.AbstractExceptionMapper;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.resteasy.spi.Failure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
public class XltestExceptionMapper
extends AbstractExceptionMapper
implements ExceptionMapper<RuntimeException> {
    private static final Logger LOG = LoggerFactory.getLogger(XltestExceptionMapper.class);

    public Response toResponse(RuntimeException exception) {
        if (exception instanceof Failure) {
            throw exception;
        }
        Map<String, Object> response = this.getBaseResponse();
        response.put("message", "Unexpected error occurred");
        response.put("status", 500);
        LOG.error("Error with id={}", response.get("id"), (Object)exception);
        return Response.status((int)500).type("application/json").entity(response).build();
    }
}

