/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service.licenseinstallservice;

import com.google.common.io.Files;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xltest.domain.RegistrationInfo;
import com.xebialabs.xltest.service.licenseinstallservice.LicenseFileAccessException;
import com.xebialabs.xltest.service.licenseinstallservice.LicenseInstallService;
import com.xebialabs.xltest.service.licenseinstallservice.LicenseInstallationFailedException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.json.JsonObject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseInstallServiceImpl
implements LicenseInstallService {
    private final File licenseFile;
    private final String baseUrl;
    private final Client client;
    private final LicenseService licenseService;
    private static final Logger LOG = LoggerFactory.getLogger(LicenseInstallServiceImpl.class);

    public LicenseInstallServiceImpl(String licensePath, LicenseService licenseService, String baseUrl) {
        this.licenseFile = new File(licensePath);
        this.baseUrl = baseUrl;
        this.licenseService = licenseService;
        this.client = ClientBuilder.newClient();
    }

    @Override
    public void downloadAndInstallLicense(String product, String licenseType, RegistrationInfo registrationInfo) {
        String link = this.downloadLicenseUrl(product, licenseType, registrationInfo);
        String licenseText = this.downloadLicense(link);
        this.installNewLicense(licenseText);
    }

    @Override
    public void verifyCanInstallNewLicense() {
        if (!this.licenseFile.canWrite()) {
            throw new LicenseFileAccessException();
        }
    }

    @Override
    public void downloadAndInstallLicense(String product, RegistrationInfo registrationInfo) {
        this.downloadAndInstallLicense(product, "free", registrationInfo);
    }

    @Override
    public String downloadLicenseUrl(String product, String licenseType, RegistrationInfo registrationInfo) {
        Response response;
        if (!registrationInfo.isValid()) {
            throw new IllegalArgumentException("RegistrationInfo misses information: " + registrationInfo.toString());
        }
        LOG.info("Requesting license from server [{}]", (Object)this.baseUrl);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.baseUrl).path(product).path(licenseType);
        WebTarget target = this.client.target(uriBuilder);
        JsonObject jsonObject = registrationInfo.toJsonObject();
        Invocation invocation = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildPost(Entity.entity((Object)jsonObject.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        try {
            response = invocation.invoke();
        }
        catch (Exception e) {
            LOG.debug("Could not download license. License server can not be reached.", (Throwable)e);
            throw new LicenseInstallationFailedException("Could not download license. License server can not be reached.");
        }
        if (response.getStatus() == 200) {
            Map result = (Map)response.readEntity(Map.class);
            return (String)result.get("link");
        }
        LOG.debug("Could not download license. Got response: {}", (Object)response.getStatus());
        throw new LicenseInstallationFailedException("Could not download license. Got response: " + response.getStatus());
    }

    @Override
    public String downloadLicense(String link) {
        try {
            return (String)this.client.target(link).request().get(String.class);
        }
        catch (Exception e) {
            LOG.debug("Could not install license. Got response {}", (Throwable)e);
            throw new LicenseInstallationFailedException("Could not install license.", e);
        }
    }

    @Override
    public void installNewLicense(String licenseText) {
        this.verifyCanInstallNewLicense();
        try {
            File tempFile = File.createTempFile("license", "tmp");
            Files.write((CharSequence)licenseText, (File)tempFile, (Charset)StandardCharsets.UTF_8);
            License tmpLicense = LicenseReader.readLicense((File)tempFile);
            this.licenseService.validate(tmpLicense);
            Files.copy((File)tempFile, (File)this.licenseFile);
            LOG.info("Wrote license to license file. Reloading the license.");
            this.licenseService.reload();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

