/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils;

import com.xebialabs.overthere.OverthereFile;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternBasedFileMatcher {
    private String prefix;

    public PatternBasedFileMatcher(String prefix) {
        this.prefix = prefix;
    }

    public List<OverthereFile> getFilesToCopy(OverthereFile startDirectory) {
        ArrayList<OverthereFile> results = new ArrayList<OverthereFile>();
        for (OverthereFile file : startDirectory.listFiles()) {
            if (file.isDirectory()) {
                if (this.matches(file.getName(), this.prefix)) {
                    results.add(file);
                    continue;
                }
                results.addAll(this.getFilesToCopy(file));
                continue;
            }
            if (!this.matches(file.getName(), this.prefix)) continue;
            results.add(file);
        }
        return results;
    }

    private boolean matches(String name, String prefix) {
        Pattern p = Pattern.compile(prefix);
        Matcher m = p.matcher(name);
        return m.matches();
    }
}

