/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils;

import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;
import org.springframework.util.StringUtils;

public class PeriodToDates {
    private final DateTime endDate;

    public PeriodToDates(DateTime endDate) {
        this.endDate = (endDate != null ? endDate : DateTime.now()).plusDays(1).withTimeAtStartOfDay().minusSeconds(1);
    }

    public DateTime getBeginDateOf(String range) {
        if (StringUtils.hasText((String)range)) {
            Period period = this.getPeriod(range);
            return this.endDate.minus((ReadablePeriod)period).plusDays(1).withTimeAtStartOfDay();
        }
        return this.endDate.minusWeeks(2).plusDays(1).withTimeAtStartOfDay();
    }

    private Period getPeriod(String range) {
        if (range.startsWith("P")) {
            return ISOPeriodFormat.standard().parsePeriod(range);
        }
        return ISOPeriodFormat.standard().parsePeriod("P" + range);
    }

    public DateTime getEndDateWithTimeEndOfDay() {
        return this.endDate;
    }
}

