/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.cucumber;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.ImportFailedException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.domain.NothingToImportException;
import com.xebialabs.xltest.importers.ImporterUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberReportJsonImporter
implements Importable {
    private static final Logger LOG = LoggerFactory.getLogger(CucumberReportJsonImporter.class);
    private final OverthereFile cucumberReportJsonFile;

    public CucumberReportJsonImporter(OverthereFile cucumberReportJsonFile) {
        this.cucumberReportJsonFile = cucumberReportJsonFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(UUID testRunId, EventHandler eventHandler) throws ImportException {
        long started = this.cucumberReportJsonFile.lastModified();
        ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"importStarted", (Map)Event.props((Object[])new Object[]{"lastModified", started, "fileName", this.cucumberReportJsonFile.getPath()}));
        int totalDuration = 0;
        try {
            List features;
            try (InputStream fis = this.cucumberReportJsonFile.getInputStream();){
                features = (List)JsonProviderFactory.createProvider().parse(fis);
            }
            catch (IOException | ClassCastException e) {
                throw new NothingToImportException("Could not process file " + this.cucumberReportJsonFile, (Throwable)e);
            }
            try {
                for (Object feature : features) {
                    int duration = this.tellAboutFeature((Map)feature, testRunId, eventHandler);
                    totalDuration += duration;
                }
            }
            catch (ClassCastException e) {
                throw new ImportFailedException("Could not process file " + this.cucumberReportJsonFile, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"importFinished", (Map)Event.props((Object[])new Object[]{"duration", totalDuration}));
            throw throwable;
        }
        ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"importFinished", (Map)Event.props((Object[])new Object[]{"duration", totalDuration}));
        LOG.info("Generated start / finish event for file: " + this.cucumberReportJsonFile.getPath());
    }

    private int tellAboutFeature(Map<String, Object> feature, UUID testRunId, EventHandler eventHandler) throws ImportException {
        List scenarios;
        String featureId = (String)JsonPath.read(feature, (String)"id", (Filter[])new Filter[0]);
        String featureName = (String)JsonPath.read(feature, (String)"name", (Filter[])new Filter[0]);
        List<String> featureTags = this.readTags(feature);
        try {
            scenarios = (List)JsonPath.read(feature, (String)"elements[?(@.type == 'scenario')]", (Filter[])new Filter[0]);
        }
        catch (InvalidPathException e) {
            scenarios = Collections.emptyList();
        }
        int totalDurationInMillis = 0;
        for (Map scenario : scenarios) {
            int duration = this.scenarioDuration(scenario);
            String scenarioResult = this.scenarioResult(scenario);
            Event event = new Event(testRunId, "functionalResult", Event.props((Object[])new Object[]{"result", scenarioResult, "duration", duration, "featureId", featureId, "id", JsonPath.read((Object)scenario, (String)"id", (Filter[])new Filter[0]), "name", featureName + ";" + JsonPath.read((Object)scenario, (String)"name", (Filter[])new Filter[0]) + ";" + JsonPath.read((Object)scenario, (String)"line", (Filter[])new Filter[0]), "steps", JsonPath.read((Object)scenario, (String)"steps", (Filter[])new Filter[0])}));
            ImporterUtil.sendEvent((EventHandler)eventHandler, (Event)event);
            totalDurationInMillis += duration;
        }
        return totalDurationInMillis;
    }

    private List<String> readTags(Map<String, Object> feature) {
        try {
            return (List)JsonPath.read(feature, (String)"$.tags[*].name", (Filter[])new Filter[0]);
        }
        catch (InvalidPathException e) {
            return Collections.emptyList();
        }
    }

    private String scenarioResult(Map<String, Object> scenario) {
        List results = (List)JsonPath.read(scenario, (String)"$.steps[*].result.status", (Filter[])new Filter[0]);
        for (String result : results) {
            if ("passed".equals(result)) continue;
            return "FAILED";
        }
        return "PASSED";
    }

    private int scenarioDuration(Map<String, Object> scenario) {
        List durations = (List)JsonPath.read(scenario, (String)"$.steps[*].result.duration", (Filter[])new Filter[0]);
        long total = 0L;
        for (Number duration : durations) {
            total += duration.longValue();
        }
        return (int)(total / 1000000L);
    }

    private List<String> scenarioTags(Map<String, Object> scenario, List<String> featureTags) {
        ArrayList<String> tags = new ArrayList<String>(featureTags);
        List<String> scenarioTags = this.readTags(scenario);
        tags.addAll(scenarioTags);
        return tags;
    }

    public long getTimestamp() {
        return this.cucumberReportJsonFile.lastModified();
    }
}

