/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicensePropertyMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class License {
    public static final String PRODUCT_XL_DEPLOY = "XL Deploy";
    public static final String PRODUCT_OLD_DEPLOYIT = "Deployit";
    public static final String PRODUCT_XL_RELEASE = "XL Release";
    public static final String PRODUCT_XL_TESTVIEW = "XL TestView";
    public static final Set<String> PRODUCTS = Sets.newHashSet((Object[])new String[]{"XL Deploy", "XL Release", "Deployit", "XL TestView"});
    public static final DateTimeFormatter LICENSE_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private LicensePropertyMap values;

    protected License(LicensePropertyMap values) {
        this.values = values;
        this.validateLicenseFormat();
    }

    public abstract List<LicenseProperty> getLicenseProperties();

    public abstract List<LicenseProperty> getRequiredProperties();

    public abstract String getLicenseVersion();

    protected void validateProperties() {
        this.validateRequired();
    }

    private void validateRequired() {
        for (LicenseProperty licenseProperty : this.getRequiredProperties()) {
            if (this.hasLicenseProperty(licenseProperty)) continue;
            throw new InvalidLicenseException(this.emptyErrorMessage(licenseProperty));
        }
    }

    private void validateProduct() {
        String product = (String)this.values.get(LicenseProperty.PRODUCT);
        if (!PRODUCTS.contains(product)) {
            throw new InvalidLicenseException(String.format("product should be one of: %s got '%s'", PRODUCTS, product));
        }
    }

    public void validateLicenseFormat() {
        this.validateProperties();
        this.validateProduct();
    }

    public boolean isDateExpired() {
        LocalDate localDateValue = this.getLocalDateValue(LicenseProperty.EXPIRES_AFTER);
        return localDateValue != null && LocalDate.now().isAfter((ReadablePartial)localDateValue);
    }

    public String getStringValue(LicenseProperty key) {
        return this.values.getAsString(key);
    }

    public boolean isDummyLicense() {
        return false;
    }

    public LocalDate getLocalDateValue(LicenseProperty key) {
        return (LocalDate)this.values.get(key);
    }

    public Map<String, Integer> getMapValue(LicenseProperty key) {
        return (Map)this.values.get(key);
    }

    public List<String> getListValue(LicenseProperty property) {
        return Lists.newArrayList((Iterable)((List)this.values.get(property)));
    }

    public boolean hasLicenseProperty(LicenseProperty key) {
        return this.values.containsKey(key);
    }

    private String emptyErrorMessage(LicenseProperty property) {
        return String.format("'%s' cannot be empty", property.getName().toLowerCase());
    }

    private String formatAll(String format) {
        StringBuilder collector = new StringBuilder();
        for (LicenseProperty licenseProperty : this.getLicenseProperties()) {
            this.values.format(collector, format, licenseProperty);
        }
        return collector.toString();
    }

    public String toLicenseContent() {
        return this.formatAll("%s: %s\n");
    }

    public String toString() {
        return this.formatAll("%-" + String.valueOf(LicenseProperty.getLongerNameLength()) + "s: %s\n");
    }

    public boolean isAtLeastVersion(String minimumLicenseVersion) {
        String licenseVersion = this.getLicenseVersion();
        int i = licenseVersion.compareTo(minimumLicenseVersion);
        return i >= 0;
    }
}

