/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.license.DummyLicense;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.service.AbstractLicenseService;
import com.xebialabs.license.service.LicenseService;
import java.io.File;
import java.io.IOException;

public class RegistrationLicenseService
extends AbstractLicenseService
implements LicenseService {
    public RegistrationLicenseService(String licensePath, String product) throws IOException {
        this(licensePath, product, "1");
    }

    public RegistrationLicenseService(String licensePath, String product, String minimumLicenseVersion) throws IOException {
        super(licensePath, product, minimumLicenseVersion);
        this.license = this.readLicense(this.licenseFile);
        if (this.license.isDateExpired()) {
            this.logLicenseError(this.licenseFile);
        }
    }

    @Override
    protected License readLicense(File licenseFile) {
        String licenseFilePath = licenseFile.getAbsolutePath();
        if (!licenseFile.exists()) {
            return DummyLicense.create();
        }
        log.info("Reading license from file {}", (Object)licenseFilePath);
        License license = LicenseReader.readLicense(licenseFile);
        log.info(license.toLicenseContent());
        if (license.isDateExpired()) {
            log.warn("*** License has expired.");
        }
        return license;
    }
}

