/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.xltest.Statistics;
import com.xebialabs.xltest.domain.PerformanceResultsSummary;
import java.util.ArrayList;
import java.util.List;

public class SamplingPerformanceResultsSummary
extends PerformanceResultsSummary {
    private List<Long> responseTimesOk = new ArrayList<Long>();
    private List<Long> responseTimesNotOk = new ArrayList<Long>();

    public void updateWithSample(long timestamp, long elapsed, String sampleResult) {
        if (timestamp < this.earliestTimestamp) {
            this.earliestTimestamp = timestamp;
        }
        if (timestamp > this.latestTimestamp) {
            this.latestTimestamp = timestamp;
        }
        if ("true".equals(sampleResult)) {
            this.responseTimesOk.add(elapsed);
            if (elapsed < this.minResponseTimeOk) {
                this.minResponseTimeOk = elapsed;
            }
            if (elapsed > this.maxResponseTimeOk) {
                this.maxResponseTimeOk = elapsed;
            }
            ++this.totalNumberOfOkRequests;
        } else if ("false".equals(sampleResult)) {
            this.responseTimesNotOk.add(elapsed);
            if (elapsed < this.minResponseTimeNotOk) {
                this.minResponseTimeNotOk = elapsed;
            }
            if (elapsed > this.maxResponseTimeNotOk) {
                this.maxResponseTimeNotOk = elapsed;
            }
            ++this.totalNumberOfNotOkRequests;
        }
        ++this.totalNumberOfRequests;
    }

    @Override
    public int getDuration() {
        return (int)(this.latestTimestamp - this.earliestTimestamp);
    }

    @Override
    protected double getStandardDeviation() {
        return this.calculateStandardDeviation(this.getAllResponseTimes());
    }

    @Override
    protected double getStandardDeviationOk() {
        return this.calculateStandardDeviation(this.responseTimesOk);
    }

    @Override
    protected double getStandardDeviationNotOk() {
        return this.calculateStandardDeviation(this.responseTimesNotOk);
    }

    private double calculateStandardDeviation(List<Long> responseTimes) {
        double sd = Statistics.calculateStandardDeviation(responseTimes);
        return Double.isNaN(sd) ? 0.0 : sd;
    }

    @Override
    protected long getMeanResponseTime() {
        return this.isAllEmpty() ? 0L : (long)Statistics.calculateMean(this.getAllResponseTimes());
    }

    @Override
    protected long getMeanResponseTimeOk() {
        return this.responseTimesOk.isEmpty() ? 0L : (long)Statistics.calculateMean(this.responseTimesOk);
    }

    @Override
    protected long getMeanResponseTimeNotOk() {
        return this.responseTimesNotOk.isEmpty() ? 0L : (long)Statistics.calculateMean(this.responseTimesNotOk);
    }

    private boolean isAllEmpty() {
        return this.responseTimesOk.isEmpty() && this.responseTimesNotOk.isEmpty();
    }

    private List<Long> getAllResponseTimes() {
        ArrayList<Long> responseTimes = new ArrayList<Long>();
        responseTimes.addAll(this.responseTimesOk);
        responseTimes.addAll(this.responseTimesNotOk);
        return responseTimes;
    }

    @Override
    public long getMinResponseTime() {
        return Math.min(this.minResponseTimeOk, this.minResponseTimeNotOk);
    }

    @Override
    protected long getMaxResponseTime() {
        return Math.max(this.maxResponseTimeOk, this.maxResponseTimeNotOk);
    }
}

