/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.xunit;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.AlreadyImportedException;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.domain.NothingToImportException;
import com.xebialabs.xltest.importers.ImporterUtil;
import com.xebialabs.xltest.xunit.XUnitReportXmlImporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XUnitImporter
implements Importable {
    private static Logger LOG = LoggerFactory.getLogger(XUnitImporter.class);
    private final OverthereFile searchPath;
    private final String searchPattern;
    private final Collection<OverthereFile> testResultFiles;
    private final long lastModified;

    public XUnitImporter(OverthereFile searchPath, String searchPattern, Collection<OverthereFile> testResultFiles) throws ImportException {
        this.searchPath = searchPath;
        this.searchPattern = searchPattern;
        this.testResultFiles = this.sorted(testResultFiles);
        this.lastModified = this.validateTestResultFilesAndReturnLastModifiedTime();
    }

    private long validateTestResultFilesAndReturnLastModifiedTime() throws ImportException {
        if (this.testResultFiles.isEmpty()) {
            throw new NothingToImportException(String.format("No test results found in '%s' with pattern '%s'", this.searchPath, this.searchPattern));
        }
        long lastModified = -1L;
        for (OverthereFile testResult : this.testResultFiles) {
            XUnitReportXmlImporter xmlImporter = new XUnitReportXmlImporter(testResult);
            long ts = xmlImporter.getLastModified();
            if (ts == 0L) {
                LOG.debug("Timestamp is 0 for file; falling back to file last modified.");
                ts = testResult.lastModified();
            }
            if (ts <= lastModified) continue;
            lastModified = ts;
        }
        if (lastModified == -1L) {
            throw new NothingToImportException(String.format("No valid test results found in set %s", this.testResultFiles));
        }
        return lastModified;
    }

    public void doImport(UUID testRunId, EventHandler eventHandler) throws ImportException {
        boolean emitImportStartedEvent = true;
        int totalDuration = 0;
        try {
            for (OverthereFile testResult : this.testResultFiles) {
                String moduleName = XUnitImporter.moduleName(this.searchPath, testResult);
                XUnitReportXmlImporter xmlImporter = new XUnitReportXmlImporter(moduleName, testResult);
                try {
                    if (emitImportStartedEvent) {
                        ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"importStarted", (Map)Event.props((Object[])new Object[]{"lastModified", this.lastModified, "fileName", this.searchPattern}));
                        emitImportStartedEvent = false;
                    }
                    totalDuration += xmlImporter.doImport(testRunId, eventHandler);
                }
                catch (NothingToImportException e) {
                    LOG.info("Nothing to import for file {}", (Object)testResult);
                }
            }
        }
        catch (AlreadyImportedException e) {
            try {
                LOG.info("Skipping import for {}, since we already found a similar import in the repository: {}", (Object)this.lastModified, (Object)e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"importFinished", (Map)Event.props((Object[])new Object[]{"duration", totalDuration}));
                throw throwable;
            }
        }
        ImporterUtil.sendEvent((EventHandler)eventHandler, (UUID)testRunId, (String)"importFinished", (Map)Event.props((Object[])new Object[]{"duration", totalDuration}));
    }

    public long getTimestamp() {
        return this.lastModified;
    }

    private Collection<OverthereFile> sorted(Collection<OverthereFile> testResultFiles) {
        ArrayList<OverthereFile> files = new ArrayList<OverthereFile>(testResultFiles);
        Collections.sort(files, new Comparator<OverthereFile>(){

            @Override
            public int compare(OverthereFile o1, OverthereFile o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return files;
    }

    public static String moduleName(OverthereFile searchPath, OverthereFile resultsPath) {
        if (resultsPath == null) {
            return null;
        }
        if (searchPath.equals(resultsPath.getParentFile())) {
            return resultsPath.getName();
        }
        return XUnitImporter.moduleName(searchPath, resultsPath.getParentFile());
    }

    public static boolean haveValidFiles(Collection<OverthereFile> testResultFiles) {
        return false;
    }
}

