/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mustache.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.elasticsearch.common.mustache.MustacheException;
import org.elasticsearch.common.mustache.ObjectHandler;
import org.elasticsearch.common.mustache.reflect.Guard;
import org.elasticsearch.common.mustache.reflect.GuardedWrapper;
import org.elasticsearch.common.mustache.reflect.ReflectionObjectHandler;
import org.elasticsearch.common.mustache.util.GuardException;
import org.elasticsearch.common.mustache.util.Wrapper;

public class ReflectionWrapper
extends GuardedWrapper {
    protected final int scopeIndex;
    protected final Wrapper[] wrappers;
    protected final ObjectHandler oh;
    protected final Method method;
    protected final Field field;
    protected final Object[] arguments;

    public ReflectionWrapper(int scopeIndex, Wrapper[] wrappers, Guard[] guard, AccessibleObject method, Object[] arguments, ObjectHandler oh) {
        super(guard);
        this.wrappers = wrappers;
        this.oh = oh;
        if (method instanceof Field) {
            this.method = null;
            this.field = (Field)method;
        } else {
            this.method = (Method)method;
            this.field = null;
        }
        this.arguments = arguments;
        this.scopeIndex = scopeIndex;
    }

    public ReflectionWrapper(ReflectionWrapper rw) {
        this(rw.scopeIndex, rw.wrappers, rw.guards, rw.method == null ? rw.field : rw.method, rw.arguments, rw.oh);
    }

    protected Object unwrap(Object[] scopes) {
        if (this.wrappers == null || this.wrappers.length == 0) {
            return scopes[this.scopeIndex];
        }
        return ReflectionObjectHandler.unwrap(this.oh, this.scopeIndex, this.wrappers, scopes);
    }

    @Override
    public Object call(Object[] scopes) throws GuardException {
        try {
            this.guardCall(scopes);
            Object scope = this.unwrap(scopes);
            if (scope == null) {
                return null;
            }
            if (this.method == null) {
                return this.field.get(scope);
            }
            return this.method.invoke(scope, this.arguments);
        }
        catch (InvocationTargetException e) {
            throw new MustacheException("Failed to execute method: " + this.method, e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new MustacheException("Failed to execute method: " + this.method, e);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.field == null) {
            sb.append(this.method.toString());
            if (this.arguments != null) {
                for (Object arg : this.arguments) {
                    sb.append(",").append(arg);
                }
            }
        } else {
            sb.append(this.field);
        }
        return sb.toString();
    }

    public Wrapper[] getWrappers() {
        return this.wrappers;
    }
}

