/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexComponent;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class AbstractIndexComponent
implements IndexComponent {
    protected final ESLogger logger;
    protected final Index index;
    protected final Settings indexSettings;
    protected final Settings componentSettings;

    protected AbstractIndexComponent(Index index, @IndexSettings Settings indexSettings) {
        this.index = index;
        this.indexSettings = indexSettings;
        this.componentSettings = indexSettings.getComponentSettings(this.getClass());
        this.logger = Loggers.getLogger(this.getClass(), indexSettings, index, new String[0]);
    }

    protected AbstractIndexComponent(Index index, @IndexSettings Settings indexSettings, String prefixSettings) {
        this.index = index;
        this.indexSettings = indexSettings;
        this.componentSettings = indexSettings.getComponentSettings(prefixSettings, this.getClass());
        this.logger = Loggers.getLogger(this.getClass(), indexSettings, index, new String[0]);
    }

    @Override
    public Index index() {
        return this.index;
    }

    public String nodeName() {
        return this.indexSettings.get("name", "");
    }
}

