/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.internal.SearchContext;

public class AggregatorParsers {
    public static final Pattern VALID_AGG_NAME = Pattern.compile("[^\\[\\]>]+");
    private final ImmutableMap<String, Aggregator.Parser> parsers;

    @Inject
    public AggregatorParsers(Set<Aggregator.Parser> parsers) {
        MapBuilder<String, Aggregator.Parser> builder = MapBuilder.newMapBuilder();
        for (Aggregator.Parser parser : parsers) {
            builder.put(parser.type(), parser);
        }
        this.parsers = builder.immutableMap();
    }

    public Aggregator.Parser parser(String type) {
        return this.parsers.get(type);
    }

    public AggregatorFactories parseAggregators(XContentParser parser, SearchContext context) throws IOException {
        return this.parseAggregators(parser, context, 0);
    }

    private AggregatorFactories parseAggregators(XContentParser parser, SearchContext context, int level) throws IOException {
        Matcher validAggMatcher = VALID_AGG_NAME.matcher("");
        AggregatorFactories.Builder factories = new AggregatorFactories.Builder();
        XContentParser.Token token = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [aggs]: aggregations definitions must start with the name of the aggregation.");
            }
            String aggregationName = parser.currentName();
            if (!validAggMatcher.reset(aggregationName).matches()) {
                throw new SearchParseException(context, "Invalid aggregation name [" + aggregationName + "]. Aggregation names must be alpha-numeric and can only contain '_' and '-'");
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new SearchParseException(context, "Aggregation definition for [" + aggregationName + " starts with a [" + (Object)((Object)token) + "], expected a [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "].");
            }
            AggregatorFactory factory = null;
            AggregatorFactories subFactories = null;
            block8: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new SearchParseException(context, "Expected [" + (Object)((Object)XContentParser.Token.FIELD_NAME) + "] under a [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "], but got a [" + (Object)((Object)token) + "] in [" + aggregationName + "]");
                }
                String fieldName = parser.currentName();
                token = parser.nextToken();
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new SearchParseException(context, "Expected [" + (Object)((Object)XContentParser.Token.START_OBJECT) + "] under [" + fieldName + "], but got a [" + (Object)((Object)token) + "] in [" + aggregationName + "]");
                }
                switch (fieldName) {
                    case "aggregations": 
                    case "aggs": {
                        if (subFactories != null) {
                            throw new SearchParseException(context, "Found two sub aggregation definitions under [" + aggregationName + "]");
                        }
                        subFactories = this.parseAggregators(parser, context, level + 1);
                        continue block8;
                    }
                }
                if (factory != null) {
                    throw new SearchParseException(context, "Found two aggregation type definitions in [" + aggregationName + "]: [" + factory.type + "] and [" + fieldName + "]");
                }
                Aggregator.Parser aggregatorParser = this.parser(fieldName);
                if (aggregatorParser == null) {
                    throw new SearchParseException(context, "Could not find aggregator type [" + fieldName + "] in [" + aggregationName + "]");
                }
                factory = aggregatorParser.parse(aggregationName, parser, context);
            }
            if (factory == null) {
                throw new SearchParseException(context, "Missing definition for aggregation [" + aggregationName + "]");
            }
            if (subFactories != null) {
                factory.subFactories(subFactories);
            }
            if (level == 0) {
                factory.validate();
            }
            factories.add(factory);
        }
        return factories.build();
    }
}

