/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.cardinality;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.cardinality.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public final class InternalCardinality
extends InternalNumericMetricsAggregation.SingleValue
implements Cardinality {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("cardinality");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalCardinality readResult(StreamInput in) throws IOException {
            InternalCardinality result = new InternalCardinality();
            result.readFrom(in);
            return result;
        }
    };
    private HyperLogLogPlusPlus counts;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalCardinality(String name, HyperLogLogPlusPlus counts, @Nullable ValueFormatter formatter) {
        super(name);
        this.counts = counts;
        this.valueFormatter = formatter;
    }

    private InternalCardinality() {
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public long getValue() {
        return this.counts == null ? 0L : this.counts.cardinality(0L);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.counts = in.readBoolean() ? HyperLogLogPlusPlus.readFrom(in, BigArrays.NON_RECYCLING_INSTANCE) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        if (this.counts != null) {
            out.writeBoolean(true);
            this.counts.writeTo(0L, out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        List<InternalAggregation> aggregations = reduceContext.aggregations();
        InternalCardinality reduced = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalCardinality cardinality = (InternalCardinality)aggregation;
            if (cardinality.counts == null) continue;
            if (reduced == null) {
                reduced = new InternalCardinality(this.name, new HyperLogLogPlusPlus(cardinality.counts.precision(), BigArrays.NON_RECYCLING_INSTANCE, 1L), this.valueFormatter);
            }
            reduced.merge(cardinality);
        }
        if (reduced == null) {
            return aggregations.get(0);
        }
        return reduced;
    }

    public void merge(InternalCardinality other) {
        assert (this.counts != null && other != null);
        this.counts.merge(0L, other.counts, 0L);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        long cardinality = this.getValue();
        builder.field(InternalAggregation.CommonFields.VALUE, cardinality);
        if (this.valueFormatter != null) {
            builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(cardinality));
        }
        return builder;
    }
}

