/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.sum;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.sum.InternalSum;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class SumAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ValuesSource.Numeric valuesSource;
    private SortedNumericDoubleValues values;
    private DoubleArray sums;
    private ValueFormatter formatter;

    public SumAggregator(String name, long estimatedBucketsCount, ValuesSource.Numeric valuesSource, @Nullable ValueFormatter formatter, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.sums = this.bigArrays.newDoubleArray(initialSize, true);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.doubleValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        this.sums = this.bigArrays.grow(this.sums, owningBucketOrdinal + 1L);
        this.values.setDocument(doc);
        int valuesCount = this.values.count();
        double sum = 0.0;
        for (int i = 0; i < valuesCount; ++i) {
            sum += this.values.valueAt(i);
        }
        this.sums.increment(owningBucketOrdinal, sum);
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.valuesSource == null ? 0.0 : this.sums.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalSum(this.name, 0.0, this.formatter);
        }
        return new InternalSum(this.name, this.sums.get(owningBucketOrdinal), this.formatter);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalSum(this.name, 0.0, this.formatter);
    }

    @Override
    public void doClose() {
        Releasables.close(this.sums);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig) {
            super(name, InternalSum.TYPE.name(), valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new SumAggregator(this.name, 0L, null, this.config.formatter(), aggregationContext, parent);
        }

        @Override
        protected Aggregator create(ValuesSource.Numeric valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new SumAggregator(this.name, expectedBucketsCount, valuesSource, this.config.formatter(), aggregationContext, parent);
        }
    }
}

