/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.range.InternalRangeFacet;
import org.elasticsearch.search.facet.range.RangeFacet;
import org.elasticsearch.search.internal.SearchContext;

public class KeyValueRangeFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData keyIndexFieldData;
    private final IndexNumericFieldData valueIndexFieldData;
    private final RangeFacet.Entry[] entries;

    public KeyValueRangeFacetExecutor(IndexNumericFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, RangeFacet.Entry[] entries, SearchContext context) {
        this.entries = entries;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalRangeFacet(facetName, this.entries);
    }

    public static class RangeProc
    extends DoubleFacetAggregatorBase {
        private final RangeFacet.Entry[] entries;
        SortedNumericDoubleValues valueValues;

        public RangeProc(RangeFacet.Entry[] entries) {
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double value) {
            for (RangeFacet.Entry entry : this.entries) {
                if (entry.foundInDoc || !(value >= entry.getFrom()) || !(value < entry.getTo())) continue;
                entry.foundInDoc = true;
                ++entry.count;
                this.valueValues.setDocument(docId);
                int seek = this.valueValues.count();
                for (int i = 0; i < seek; ++i) {
                    double valueValue = this.valueValues.valueAt(i);
                    entry.total += valueValue;
                    entry.min = Math.min(entry.min, valueValue);
                    entry.max = Math.max(entry.max, valueValue);
                }
                entry.totalCount += (long)seek;
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final RangeProc rangeProc;
        private SortedNumericDoubleValues keyValues;

        public Collector() {
            this.rangeProc = new RangeProc(KeyValueRangeFacetExecutor.this.entries);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = ((AtomicNumericFieldData)KeyValueRangeFacetExecutor.this.keyIndexFieldData.load(context)).getDoubleValues();
            this.rangeProc.valueValues = ((AtomicNumericFieldData)KeyValueRangeFacetExecutor.this.valueIndexFieldData.load(context)).getDoubleValues();
        }

        public void collect(int doc) throws IOException {
            for (RangeFacet.Entry entry : KeyValueRangeFacetExecutor.this.entries) {
                entry.foundInDoc = false;
            }
            this.rangeProc.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
        }
    }
}

