/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import org.elasticsearch.common.compress.BufferRecycler;
import org.elasticsearch.common.compress.CompressedStreamInput;
import org.elasticsearch.common.compress.lzf.ChunkDecoder;
import org.elasticsearch.common.compress.lzf.LZFCompressorContext;
import org.elasticsearch.common.io.stream.StreamInput;

public class LZFCompressedStreamInput
extends CompressedStreamInput<LZFCompressorContext> {
    private final BufferRecycler recycler = BufferRecycler.instance();
    private final ChunkDecoder decoder;
    private byte[] inputBuffer;

    public LZFCompressedStreamInput(StreamInput in, ChunkDecoder decoder) throws IOException {
        super(in, LZFCompressorContext.INSTANCE);
        this.decoder = decoder;
        this.uncompressed = this.recycler.allocDecodeBuffer(65535);
        this.inputBuffer = this.recycler.allocInputBuffer(65535);
    }

    @Override
    public void readHeader(StreamInput in) throws IOException {
    }

    @Override
    public int uncompress(StreamInput in, byte[] out) throws IOException {
        return this.decoder.decodeChunk(in, this.inputBuffer, out);
    }

    @Override
    protected void doClose() throws IOException {
        byte[] buf = this.inputBuffer;
        if (buf != null) {
            this.inputBuffer = null;
            this.recycler.releaseInputBuffer(buf);
        }
        if ((buf = this.uncompressed) != null) {
            this.uncompressed = null;
            this.recycler.releaseDecodeBuffer(this.uncompressed);
        }
    }
}

