/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public class KeyedLock<T> {
    private final ConcurrentMap<T, KeyLock> map = ConcurrentCollections.newConcurrentMap();
    protected final ThreadLocal<KeyLock> threadLocal = new ThreadLocal();

    public void acquire(T key) {
        KeyLock perNodeLock;
        int i;
        do {
            KeyLock newLock;
            if (this.threadLocal.get() != null) {
                throw new ElasticsearchIllegalStateException("Lock already acquired in Thread" + Thread.currentThread().getId() + " for key " + key);
            }
            perNodeLock = (KeyLock)this.map.get(key);
            if (perNodeLock == null && (perNodeLock = this.map.putIfAbsent(key, newLock = new KeyLock())) == null) {
                newLock.lock();
                this.threadLocal.set(newLock);
                return;
            }
            assert (perNodeLock != null);
        } while ((i = perNodeLock.count.get()) <= 0 || !perNodeLock.count.compareAndSet(i, i + 1));
        perNodeLock.lock();
        this.threadLocal.set(perNodeLock);
    }

    public void release(T key) {
        KeyLock lock = this.threadLocal.get();
        if (lock == null) {
            throw new ElasticsearchIllegalStateException("Lock not acquired");
        }
        this.release(key, lock);
    }

    void release(T key, KeyLock lock) {
        assert (lock.isHeldByCurrentThread());
        assert (lock == this.map.get(key));
        lock.unlock();
        this.threadLocal.set(null);
        int decrementAndGet = lock.count.decrementAndGet();
        if (decrementAndGet == 0) {
            this.map.remove(key, lock);
        }
    }

    public boolean hasLockedKeys() {
        return !this.map.isEmpty();
    }

    public static final class GlobalLockable<T>
    extends KeyedLock<T> {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acquire(T key) {
            boolean success = false;
            this.lock.readLock().lock();
            try {
                super.acquire(key);
                success = true;
            }
            finally {
                if (!success) {
                    this.lock.readLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release(T key) {
            KeyLock keyLock = (KeyLock)this.threadLocal.get();
            if (keyLock == null) {
                throw new ElasticsearchIllegalStateException("Lock not acquired");
            }
            try {
                this.release(key, keyLock);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public Lock globalLock() {
            return this.lock.writeLock();
        }
    }

    private static final class KeyLock
    extends ReentrantLock {
        private final AtomicInteger count = new AtomicInteger(1);

        private KeyLock() {
        }
    }
}

