/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.deletionpolicy;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.deletionpolicy.AbstractESDeletionPolicy;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;

public class KeepLastNDeletionPolicy
extends AbstractESDeletionPolicy {
    private final int numToKeep;

    @Inject
    public KeepLastNDeletionPolicy(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
        this.numToKeep = this.componentSettings.getAsInt("num_to_keep", (Integer)5);
        this.logger.debug("Using [keep_last_n] deletion policy with num_to_keep[{}]", this.numToKeep);
    }

    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        this.doDeletes(commits);
    }

    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        this.doDeletes(commits);
    }

    private void doDeletes(List<? extends IndexCommit> commits) {
        int size = commits.size();
        for (int i = 0; i < size - this.numToKeep; ++i) {
            commits.get(i).delete();
        }
    }
}

