/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.support;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.internal.SearchContext;

public class NestedInnerQueryParseSupport {
    protected final QueryParseContext parseContext;
    private BytesReference source;
    private Query innerQuery;
    private Filter innerFilter;
    protected String path;
    private boolean filterParsed = false;
    private boolean queryParsed = false;
    protected boolean queryFound = false;
    protected boolean filterFound = false;
    protected FixedBitSetFilter parentFilter;
    protected FixedBitSetFilter childFilter;
    protected DocumentMapper childDocumentMapper;
    protected ObjectMapper nestedObjectMapper;
    private ObjectMapper parentObjectMapper;

    public NestedInnerQueryParseSupport(XContentParser parser, SearchContext searchContext) {
        this.parseContext = searchContext.queryParserService().getParseContext();
        this.parseContext.reset(parser);
    }

    public NestedInnerQueryParseSupport(QueryParseContext parseContext) {
        this.parseContext = parseContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query() throws IOException {
        if (this.path != null) {
            this.setPathLevel();
            try {
                this.innerQuery = this.parseContext.parseInnerQuery();
            }
            finally {
                this.resetPathLevel();
            }
            this.queryParsed = true;
        } else {
            this.source = XContentFactory.smileBuilder().copyCurrentStructure(this.parseContext.parser()).bytes();
        }
        this.queryFound = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter() throws IOException {
        if (this.path != null) {
            this.setPathLevel();
            try {
                this.innerFilter = this.parseContext.parseInnerFilter();
            }
            finally {
                this.resetPathLevel();
            }
            this.filterParsed = true;
        } else {
            this.source = XContentFactory.smileBuilder().copyCurrentStructure(this.parseContext.parser()).bytes();
        }
        this.filterFound = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getInnerQuery() throws IOException {
        if (this.queryParsed) {
            return this.innerQuery;
        }
        if (this.path == null) {
            throw new QueryParsingException(this.parseContext.index(), "[nested] requires 'path' field");
        }
        if (!this.queryFound) {
            throw new QueryParsingException(this.parseContext.index(), "[nested] requires either 'query' or 'filter' field");
        }
        XContentParser old = this.parseContext.parser();
        try {
            XContentParser innerParser = XContentHelper.createParser(this.source);
            this.parseContext.parser(innerParser);
            this.setPathLevel();
            try {
                this.innerQuery = this.parseContext.parseInnerQuery();
            }
            finally {
                this.resetPathLevel();
            }
            this.queryParsed = true;
            Query query = this.innerQuery;
            return query;
        }
        finally {
            this.parseContext.parser(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getInnerFilter() throws IOException {
        if (this.filterParsed) {
            return this.innerFilter;
        }
        if (this.path == null) {
            throw new QueryParsingException(this.parseContext.index(), "[nested] requires 'path' field");
        }
        if (!this.filterFound) {
            throw new QueryParsingException(this.parseContext.index(), "[nested] requires either 'query' or 'filter' field");
        }
        this.setPathLevel();
        XContentParser old = this.parseContext.parser();
        try {
            XContentParser innerParser = XContentHelper.createParser(this.source);
            this.parseContext.parser(innerParser);
            this.innerFilter = this.parseContext.parseInnerFilter();
            this.filterParsed = true;
            Filter filter = this.innerFilter;
            return filter;
        }
        finally {
            this.resetPathLevel();
            this.parseContext.parser(old);
        }
    }

    public void setPath(String path) {
        this.path = path;
        MapperService.SmartNameObjectMapper smart = this.parseContext.smartObjectMapper(path);
        if (smart == null) {
            throw new QueryParsingException(this.parseContext.index(), "[nested] failed to find nested object under path [" + path + "]");
        }
        this.childDocumentMapper = smart.docMapper();
        this.nestedObjectMapper = smart.mapper();
        if (this.nestedObjectMapper == null) {
            throw new QueryParsingException(this.parseContext.index(), "[nested] failed to find nested object under path [" + path + "]");
        }
        if (!this.nestedObjectMapper.nested().isNested()) {
            throw new QueryParsingException(this.parseContext.index(), "[nested] nested object under path [" + path + "] is not of nested type");
        }
    }

    public String getPath() {
        return this.path;
    }

    public ObjectMapper getNestedObjectMapper() {
        return this.nestedObjectMapper;
    }

    public boolean queryFound() {
        return this.queryFound;
    }

    public boolean filterFound() {
        return this.filterFound;
    }

    public ObjectMapper getParentObjectMapper() {
        return this.parentObjectMapper;
    }

    private void setPathLevel() {
        ObjectMapper objectMapper = this.parseContext.nestedScope().getObjectMapper();
        this.parentFilter = objectMapper == null ? this.parseContext.fixedBitSetFilter(NonNestedDocsFilter.INSTANCE) : this.parseContext.fixedBitSetFilter(objectMapper.nestedTypeFilter());
        this.childFilter = this.parseContext.fixedBitSetFilter(this.nestedObjectMapper.nestedTypeFilter());
        this.parentObjectMapper = this.parseContext.nestedScope().nextLevel(this.nestedObjectMapper);
    }

    private void resetPathLevel() {
        this.parseContext.nestedScope().previousLevel();
    }
}

