/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.support;

import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class AcknowledgedRestListener<T extends AcknowledgedResponse>
extends RestBuilderListener<T> {
    public AcknowledgedRestListener(RestChannel channel) {
        super(channel);
    }

    @Override
    public RestResponse buildResponse(T response, XContentBuilder builder) throws Exception {
        builder.startObject().field(Fields.ACKNOWLEDGED, ((AcknowledgedResponse)response).isAcknowledged());
        this.addCustomFields(builder, response);
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }

    protected void addCustomFields(XContentBuilder builder, T response) throws IOException {
    }

    static final class Fields {
        static final XContentBuilderString ACKNOWLEDGED = new XContentBuilderString("acknowledged");

        Fields() {
        }
    }
}

