/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;

public class KeyProviderUtil {
    public static KeyFormat detectKeyFileFormat(File location) throws IOException {
        return KeyProviderUtil.detectKeyFileFormat(new FileReader(location), new File(location + ".pub").exists());
    }

    public static KeyFormat detectKeyFileFormat(String privateKey, boolean separatePubKey) throws IOException {
        return KeyProviderUtil.detectKeyFileFormat(new StringReader(privateKey), separatePubKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyFormat detectKeyFileFormat(Reader privateKey, boolean separatePubKey) throws IOException {
        String firstLine;
        BufferedReader br = new BufferedReader(privateKey);
        try {
            firstLine = br.readLine();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(br);
            throw throwable;
        }
        IOUtils.closeQuietly(br);
        if (firstLine == null) {
            throw new IOException("Empty file");
        }
        if (firstLine.startsWith("-----BEGIN") && firstLine.endsWith("PRIVATE KEY-----")) {
            if (separatePubKey) {
                return KeyFormat.OpenSSH;
            }
            return KeyFormat.PKCS8;
        }
        if (firstLine.startsWith("PuTTY-User-Key-File-")) {
            return KeyFormat.PuTTY;
        }
        return KeyFormat.Unknown;
    }
}

