/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileTree
extends File {
    private static final long serialVersionUID = 3396907770563704920L;

    public FileTree(String name) {
        super(name);
    }

    public FileTree(File file, String name) {
        super(file, name);
    }

    public FileTree(String n1, String n2) {
        super(n1, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(File copyFile) throws IOException {
        if (this.isDirectory()) {
            copyFile.mkdirs();
            String[] dirs = this.list();
            for (int i = dirs.length - 1; i >= 0; --i) {
                new FileTree(this, dirs[i]).copyTo(new File(copyFile, dirs[i]));
            }
        } else {
            InputStream is = null;
            OutputStream os = null;
            try {
                int n;
                is = new BufferedInputStream(new FileInputStream(this));
                os = new BufferedOutputStream(new FileOutputStream(copyFile));
                byte[] buf = new byte[4096];
                while ((n = is.read(buf)) >= 0) {
                    os.write(buf, 0, n);
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
        }
    }

    public boolean delete() {
        String[] dirs;
        boolean allDeleted = true;
        if (this.isDirectory() && (dirs = this.list()) != null) {
            for (int i = dirs.length - 1; i >= 0; --i) {
                allDeleted &= new FileTree(this, dirs[i]).delete();
            }
        }
        boolean thisDeleted = super.delete();
        return allDeleted & thisDeleted;
    }
}

