/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.AbstractBinary;
import org.modeshape.jcr.value.binary.BinaryStore;

@Immutable
public class StoredBinaryValue
extends AbstractBinary {
    private static final long serialVersionUID = 1L;
    private final transient BinaryStore store;
    private final long size;
    private transient String mimeType;

    public StoredBinaryValue(BinaryStore store, BinaryKey key, long size) {
        super(key);
        this.store = store;
        this.size = size;
        assert (this.store != null);
        assert (this.size >= 0L);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String getMimeType() throws IOException, RepositoryException {
        if (this.mimeType == null) {
            this.mimeType = this.store.getMimeType(this, null);
        }
        return this.mimeType;
    }

    public String getMimeType(String name) throws IOException, RepositoryException {
        if (this.mimeType == null) {
            this.mimeType = this.store.getMimeType(this, name);
        }
        return this.mimeType;
    }

    @Override
    protected InputStream internalStream() throws RepositoryException {
        return this.store.getInputStream(this.getKey());
    }
}

