/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.google.common.io.ByteSource;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.io.LazyLocalFile;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;

public class SourceArtifactFile {
    private static final Class<LazyLocalFile> proxyClass = SourceArtifactFile.createProxyClass();

    private SourceArtifactFile() {
    }

    private static Class<LazyLocalFile> createProxyClass() {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(LazyLocalFile.class);
        proxyFactory.setUseCache(false);
        proxyFactory.setUseWriteReplace(false);
        return proxyFactory.createClass();
    }

    public static LazyLocalFile create(SourceArtifact artifact, String filename, WorkDir workDir) {
        try {
            Constructor<LazyLocalFile> constructor = proxyClass.getConstructor(LocalConnection.class, File.class);
            LazyLocalFile o = constructor.newInstance(LocalConnection.getLocalConnection(), null);
            ((ProxyObject)o).setHandler((MethodHandler)new LazySourceFileHandler(artifact, filename, workDir));
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create a proxy.", e);
        }
    }

    static LazyLocalFile create(LocalFile toBeWrapped, SourceArtifact rawReader) {
        try {
            Constructor<LazyLocalFile> constructor = proxyClass.getConstructor(LocalConnection.class, File.class);
            LazyLocalFile o = constructor.newInstance(LocalConnection.getLocalConnection(), null);
            ((ProxyObject)o).setHandler((MethodHandler)new ResolvedSourceFileHandler(toBeWrapped, rawReader));
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create a proxy.", e);
        }
    }

    public static class ResolvedSourceFileHandler
    implements MethodHandler,
    Serializable {
        private final LocalFile wrapped;
        private final SourceArtifact sourceArtifact;

        public ResolvedSourceFileHandler(LocalFile wrapped, SourceArtifact sourceArtifact) {
            this.wrapped = wrapped;
            this.sourceArtifact = sourceArtifact;
        }

        public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            if (thisMethod.getName().equals("getRawStream")) {
                return ArtifactResolverRegistry.resolve(this.sourceArtifact).openStream();
            }
            return thisMethod.invoke((Object)this.wrapped, args);
        }
    }

    public static class LazySourceFileHandler
    implements MethodHandler,
    Serializable {
        private SourceArtifact artifact;
        private String filename;
        private WorkDir workDir;

        public LazySourceFileHandler(SourceArtifact artifact, String filename, WorkDir workDir) {
            this.artifact = artifact;
            this.filename = filename;
            this.workDir = workDir;
        }

        public synchronized Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            if (ProxyFactory.isProxyClass(this.artifact.getFile().getClass())) {
                if (thisMethod.getName().equals("getName")) {
                    return this.filename;
                }
                if (thisMethod.getName().equals("exists")) {
                    return true;
                }
                if (thisMethod.getName().equals("isFile")) {
                    return !(this.artifact instanceof FolderArtifact);
                }
                if (thisMethod.getName().equals("isDirectory")) {
                    return this.artifact instanceof FolderArtifact;
                }
                if (thisMethod.getName().equals("getRawStream")) {
                    return this.getByteSource(ArtifactResolverRegistry.resolve(this.artifact)).openStream();
                }
                LocalFile lf = this.resolveToLocalFile();
                this.artifact.setFile((OverthereFile)SourceArtifactFile.create(lf, this.artifact));
            }
            if (thisMethod.getName().equals("underlyingArtifact")) {
                return this.artifact;
            }
            return thisMethod.invoke((Object)this.artifact.getFile(), args);
        }

        private LocalFile resolveToLocalFile() throws URISyntaxException {
            LocalFile localFile = this.workDir.newFile(this.filename);
            ResolvedArtifactFile resolvedArtifactFile = ArtifactResolverRegistry.resolve(this.artifact);
            if (this.isFolderArtifact()) {
                localFile.mkdir();
                try {
                    Exploder.explode(this.getByteSource(resolvedArtifactFile), localFile.getFile(), null);
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Could not extract data from " + this.artifact.getId() + " to directory " + localFile.getPath(), e);
                }
            }
            OutputStream outputStream = localFile.getOutputStream();
            try {
                this.getByteSource(resolvedArtifactFile).copyTo(outputStream);
            }
            catch (IOException e) {
                throw new RuntimeIOException("Could not copy data from " + this.artifact.getId() + " to file " + localFile.getPath(), e);
            }
            finally {
                Closeables.closeQuietly((Closeable)outputStream);
            }
            return localFile;
        }

        private ByteSource getByteSource(final ResolvedArtifactFile resolvedArtifactFile) {
            return new ByteSource(){

                public InputStream openStream() throws IOException {
                    final InputStream is = resolvedArtifactFile.openStream();
                    return new InputStream(){

                        @Override
                        public int read(byte[] b, int off, int len) throws IOException {
                            return is.read(b, off, len);
                        }

                        @Override
                        public int read(byte[] b) throws IOException {
                            return is.read(b);
                        }

                        @Override
                        public int read() throws IOException {
                            return is.read();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void close() throws IOException {
                            try {
                                is.close();
                            }
                            finally {
                                resolvedArtifactFile.close();
                            }
                        }
                    };
                }
            };
        }

        private boolean isFolderArtifact() {
            return this.artifact.getType().isSubTypeOf(Type.valueOf(FolderArtifact.class));
        }
    }
}

