/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;

public class BackupForBuilder
extends AbstractConfigurationChildBuilder
implements Builder<BackupForConfiguration> {
    private String remoteCache;
    private String remoteSite;

    public BackupForBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public BackupForBuilder remoteSite(String siteName) {
        this.remoteSite = siteName;
        return this;
    }

    public BackupForBuilder remoteCache(String name) {
        if (name == null) {
            throw new RuntimeException("Null name not allowed (use 'defaultRemoteCache()' in case you want to specify the default cache name).");
        }
        this.remoteCache = name;
        return this;
    }

    public BackupForBuilder defaultRemoteCache() {
        this.remoteCache = "___defaultcache";
        return this;
    }

    public void validate() {
        if (this.remoteCache == null && this.remoteSite == null) {
            return;
        }
        if (this.remoteSite == null || this.remoteCache == null) {
            throw new CacheConfigurationException("Both 'remoteCache' and 'remoteSite' must be specified for a backup'!");
        }
    }

    public BackupForConfiguration create() {
        return new BackupForConfiguration(this.remoteSite, this.remoteCache);
    }

    public Builder<?> read(BackupForConfiguration template) {
        this.remoteCache = template.remoteCache();
        this.remoteSite = template.remoteSite();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupForBuilder)) {
            return false;
        }
        BackupForBuilder that = (BackupForBuilder)o;
        if (this.remoteCache != null ? !this.remoteCache.equals(that.remoteCache) : that.remoteCache != null) {
            return false;
        }
        return !(this.remoteSite != null ? !this.remoteSite.equals(that.remoteSite) : that.remoteSite != null);
    }

    public int hashCode() {
        int result = this.remoteCache != null ? this.remoteCache.hashCode() : 0;
        result = 31 * result + (this.remoteSite != null ? this.remoteSite.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BackupForBuilder{remoteCache='" + this.remoteCache + '\'' + ", remoteSite='" + this.remoteSite + '\'' + '}';
    }

    public void reset() {
        this.remoteCache = null;
        this.remoteSite = null;
    }
}

