/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.google.common.base.Strings;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.ProjectRepository;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.service.QualificationFinder;
import java.util.Collections;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestSpecificationTreeBuilder {
    private final ProjectRepository projectRepository;
    private TestRunsRepository testRunsRepository;
    private QualificationFinder qualificationFinder;

    @Autowired
    public TestSpecificationTreeBuilder(ProjectRepository projectRepository, TestRunsRepository testRunsRepository, QualificationFinder qualificationFinder) {
        this.projectRepository = projectRepository;
        this.testRunsRepository = testRunsRepository;
        this.qualificationFinder = qualificationFinder;
    }

    public JSONArray treeForTestSpecification(String projectId) throws JSONException {
        List<BaseTestSpecification> allTestSpecifications = this.projectRepository.getTestSpecifications(projectId);
        if (allTestSpecifications == null) {
            allTestSpecifications = Collections.emptyList();
        }
        Collections.sort(allTestSpecifications, BaseTestSpecification.titleComparator);
        return this.createTestSpecificationTree(allTestSpecifications);
    }

    protected JSONArray createTestSpecificationTree(List<BaseTestSpecification> allTestSpecifications) throws JSONException {
        return this.createTestSpecificationTree(allTestSpecifications, null);
    }

    protected JSONArray createTestSpecificationTree(List<BaseTestSpecification> allTestSpecifications, BaseTestSpecification parent) throws JSONException {
        JSONArray jArray = new JSONArray();
        for (BaseTestSpecification testSpec : allTestSpecifications) {
            TestRun latestTestRuns;
            JSONObject child = new JSONObject();
            child.put("name", (Object)testSpec.getName());
            child.put("title", (Object)testSpec.getTitle());
            child.put("type", (Object)testSpec.getType());
            if (parent != null) {
                child.put("parent", (Object)parent.getName());
            }
            if (testSpec.hasProperty("testToolName")) {
                child.put("testToolName", testSpec.getProperty("testToolName"));
            }
            child.put("hasRuns", (latestTestRuns = this.testRunsRepository.getLatestTestRun(testSpec.getName(), 0L)) != null);
            QualificationResult qualificationResult = this.qualificationFinder.getQualification(testSpec);
            if (qualificationResult.getResult() == QualificationResult.Result.PASSED) {
                child.put("result", true);
            } else if (qualificationResult.getResult() == QualificationResult.Result.FAILED) {
                child.put("result", false);
            }
            if (!Strings.isNullOrEmpty((String)qualificationResult.getFailureReason())) {
                child.put("message", (Object)qualificationResult.getFailureReason());
            }
            child.put("executable", testSpec instanceof Executable && ((Executable)((Object)testSpec)).isExecutable());
            child.put("importable", testSpec instanceof ActiveTestSpecification && !(testSpec instanceof Executable));
            if (testSpec.hasProperty("testSpecifications")) {
                List children = (List)testSpec.getProperty("testSpecifications");
                child.put("testSpecifications", (Object)this.createTestSpecificationTree(children, testSpec));
            }
            jArray.put((Object)child);
        }
        return jArray;
    }
}

