/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.google.common.collect.Lists;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.repository.TestRunsRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QualificationFinder {
    private final TestRunsRepository testRunsRepository;

    @Autowired
    public QualificationFinder(TestRunsRepository testRunsRepository) {
        this.testRunsRepository = testRunsRepository;
    }

    public QualificationResult getQualification(BaseTestSpecification testSpecification) {
        if (testSpecification.hasProperty("testSpecifications")) {
            return this.calculateOverallQualification((List)testSpecification.getProperty("testSpecifications"));
        }
        Event lastQualificationEvent = this.testRunsRepository.getLatestEventOfType(testSpecification.getName(), "qualificationComputed", new Date(0L).getTime(), new Date().getTime());
        return QualificationResult.fromEvent(lastQualificationEvent);
    }

    private QualificationResult calculateOverallQualification(List<BaseTestSpecification> specifications) {
        ArrayList qualifications = Lists.newArrayList();
        for (BaseTestSpecification specification : specifications) {
            if (specification.hasProperty("testSpecifications")) {
                qualifications.add(this.calculateOverallQualification((List)specification.getProperty("testSpecifications")));
                continue;
            }
            Event lastQualificationEvent = this.testRunsRepository.getLatestEventOfType(specification.getName(), "qualificationComputed", new Date(0L).getTime(), new Date().getTime());
            qualifications.add(QualificationResult.fromEvent(lastQualificationEvent));
        }
        return this.getQualificationResult(qualifications);
    }

    public QualificationResult getQualificationResult(List<QualificationResult> qualifications) {
        if (qualifications.isEmpty()) {
            return new QualificationResult(QualificationResult.Result.NOT_FOUND, new DateTime(0L), "");
        }
        while (qualifications.size() > 1) {
            QualificationResult q1 = qualifications.remove(0);
            QualificationResult q2 = qualifications.remove(0);
            qualifications.add(0, QualificationResult.merge(q1, q2));
        }
        return qualifications.get(0);
    }

    public QualificationResult getFilteredResult(Map<String, String> query) {
        Event event = this.testRunsRepository.getLatestEventWithProperties(query);
        return QualificationResult.fromEvent(event);
    }
}

