/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.document.JsonSchema;
import org.infinispan.schematic.document.NotThreadSafe;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.schema.Problems;
import org.infinispan.schematic.internal.schema.ValidationProblem;
import org.infinispan.schematic.internal.schema.ValidationTypeMismatchProblem;

@NotThreadSafe
public class ValidationResult
implements SchemaLibrary.Results,
Problems {
    private final List<SchemaLibrary.Problem> problems = new ArrayList<SchemaLibrary.Problem>();
    private int successes;

    @Override
    public Iterator<SchemaLibrary.Problem> iterator() {
        return Collections.unmodifiableList(this.problems).iterator();
    }

    @Override
    public boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    @Override
    public boolean hasErrors() {
        for (SchemaLibrary.Problem problem : this.problems) {
            if (problem.getType() != SchemaLibrary.ProblemType.ERROR) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWarnings() {
        for (SchemaLibrary.Problem problem : this.problems) {
            if (problem.getType() != SchemaLibrary.ProblemType.WARNING) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOnlyTypeMismatchErrors() {
        boolean foundMismatch = false;
        for (SchemaLibrary.Problem problem : this.problems) {
            if (problem.getType() != SchemaLibrary.ProblemType.ERROR) continue;
            if (problem instanceof SchemaLibrary.MismatchedTypeProblem) {
                foundMismatch = true;
                continue;
            }
            return false;
        }
        return foundMismatch;
    }

    @Override
    public int errorCount() {
        int result = 0;
        for (SchemaLibrary.Problem problem : this.problems) {
            if (problem.getType() != SchemaLibrary.ProblemType.ERROR) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int warningCount() {
        int result = 0;
        for (SchemaLibrary.Problem problem : this.problems) {
            if (problem.getType() != SchemaLibrary.ProblemType.WARNING) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int problemCount() {
        return this.problems.size();
    }

    public int successCount() {
        return this.successes;
    }

    @Override
    public void recordSuccess() {
        ++this.successes;
    }

    @Override
    public void recordError(Path path, String reason) {
        this.problems.add(new ValidationProblem(SchemaLibrary.ProblemType.ERROR, path, reason, null));
    }

    @Override
    public void recordError(Path path, String reason, Throwable cause) {
        this.problems.add(new ValidationProblem(SchemaLibrary.ProblemType.ERROR, path, reason, cause));
    }

    @Override
    public void recordWarning(Path path, String reason) {
        this.problems.add(new ValidationProblem(SchemaLibrary.ProblemType.WARNING, path, reason, null));
    }

    @Override
    public void recordTypeMismatch(Path path, String reason, JsonSchema.Type actualType, Object actualValue, JsonSchema.Type requiredType, Object convertedValue) {
        this.problems.add(new ValidationTypeMismatchProblem(SchemaLibrary.ProblemType.ERROR, path, actualValue, actualType, requiredType, convertedValue, reason, null));
    }

    public void recordIn(Problems otherProblems) {
        if (this.successes == 0 && this.problems.isEmpty()) {
            return;
        }
        for (SchemaLibrary.Problem problem : this.problems) {
            for (int i = 0; i != this.successes; ++i) {
                otherProblems.recordSuccess();
            }
            switch (problem.getType()) {
                case ERROR: {
                    if (problem instanceof SchemaLibrary.MismatchedTypeProblem) {
                        SchemaLibrary.MismatchedTypeProblem mismatch = (SchemaLibrary.MismatchedTypeProblem)problem;
                        otherProblems.recordTypeMismatch(mismatch.getPath(), mismatch.getReason(), mismatch.getActualType(), mismatch.getActualValue(), mismatch.getExpectedType(), mismatch.getConvertedValue());
                        break;
                    }
                    otherProblems.recordError(problem.getPath(), problem.getReason(), problem.getCause());
                    break;
                }
                case WARNING: {
                    otherProblems.recordWarning(problem.getPath(), problem.getReason());
                }
            }
        }
    }

    public void add(SchemaLibrary.Problem problem) {
        if (problem != null) {
            this.problems.add(problem);
        }
    }

    public void addAll(Iterable<SchemaLibrary.Problem> results) {
        if (results != null) {
            for (SchemaLibrary.Problem problem : results) {
                this.problems.add(problem);
            }
        }
    }

    public void addAll(Iterator<SchemaLibrary.Results> iter) {
        if (iter != null) {
            while (iter.hasNext()) {
                this.addAll(iter.next());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SchemaLibrary.Problem problem : this.problems) {
            sb.append(problem);
            sb.append('\n');
        }
        return sb.toString();
    }
}

