/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.jcr.JcrQueryTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.QueryTemplateFactory;
import com.xebialabs.deployit.repository.SearchParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryBuilder {
    public static final String CI_SELECTOR_NAME = "ci";
    private static final String EQUALITY_OPERATOR = "=";
    private static final String LIKE_OPERATOR = "LIKE";
    private static final String NAME_IS_OPERATOR = "NAME_IS";
    private static final String NAME_LIKE_OPERATOR = "NAME_LIKE";
    private static final String ISCHILDNODE_OPERATOR = "ISCHILDNODE";
    private static final String ISDESCENDANTNODE_OPERATOR = "ISDESCENDANTNODE";
    private static final String CONTAINS_OPERATOR = "CONTAINS";
    private final SearchParameters parameters;
    private final StringBuilder joins;
    private final List<Condition> conditions;
    private int nextSelectorId = 1;
    private static final Logger logger = LoggerFactory.getLogger(SearchQueryBuilder.class);

    public SearchQueryBuilder(SearchParameters parameters) {
        this.parameters = parameters;
        this.joins = new StringBuilder();
        this.conditions = Lists.newArrayList();
        Checks.checkArgument((parameters.getName() == null || !parameters.getName().contains("'") ? 1 : 0) != 0, (String)"Name [%s] contains a single quote (')", (Object[])new Object[]{parameters.getName()});
        Checks.checkArgument((parameters.getParent() == null || !parameters.getParent().contains("'") ? 1 : 0) != 0, (String)"Parent [%s] contains a single quote (')", (Object[])new Object[]{parameters.getParent()});
    }

    protected QueryTemplate createTemplate() {
        return this.createTemplate(new QueryTemplateFactory(){

            public QueryTemplate createTemplate(String query) {
                return new JcrQueryTemplate(query);
            }

            public QueryTemplate createTemplate(String query, Map<String, Object> parameters) {
                return new JcrQueryTemplate(query, parameters);
            }
        });
    }

    protected QueryTemplate createTemplate(QueryTemplateFactory factory) {
        this.createJoinsAndConditions();
        String queryString = this.constructQueryString();
        QueryTemplate template = factory.createTemplate(queryString);
        this.addParameters(template);
        template.setResultsPerPage(this.parameters.getResultsPerPage());
        template.setPage(this.parameters.getPage());
        template.setDepth(this.parameters.getDepth());
        return template;
    }

    private String constructQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ci.* FROM [deployit:configurationItem] AS ci");
        builder.append(this.joins.toString());
        if (!this.conditions.isEmpty()) {
            builder.append(" WHERE ");
            builder.append(Joiner.on((String)" AND ").join((Iterable)Collections2.transform(this.conditions, (Function)new Function<Condition, String>(){

                public String apply(Condition input) {
                    return input.build();
                }
            })));
        }
        builder.append(" ORDER BY NAME(ci)");
        logger.trace("Query string built: {}", (Object)builder.toString());
        return builder.toString();
    }

    private void addParameters(QueryTemplate query) {
        for (Condition condition : this.conditions) {
            if (condition.parameter == null) continue;
            for (int i = 0; i < condition.values.length; ++i) {
                String key = condition.parameter + i;
                Object value = condition.values[i];
                query.setParameter(key, value);
                logger.trace("Bound {} to {}", (Object)key, value);
            }
        }
    }

    private void createJoinsAndConditions() {
        this.createConditionForParent();
        this.createConditionForAncestor();
        this.createConditionForName();
        this.createConditionForConfigurationItemTypeName();
        this.createConditionForDate();
        this.createConditionsForProperties();
        this.createConditionsForTextSearch();
    }

    private void createConditionForConfigurationItemTypeName() {
        if (this.parameters.getType() != null) {
            ArrayList types = Lists.newArrayList();
            types.add(this.parameters.getType().toString());
            for (Type subtype : DescriptorRegistry.getSubtypes((Type)this.parameters.getType())) {
                types.add(subtype.toString());
            }
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$configuration.item.type", "_configurationItemTypeName", EQUALITY_OPERATOR, false, types.toArray(new Object[types.size()])));
        }
    }

    private void createConditionForParent() {
        if (!Strings.nullToEmpty((String)this.parameters.getParent()).trim().isEmpty()) {
            String parent = Strings.nullToEmpty((String)this.parameters.getParent());
            if (!parent.startsWith("/")) {
                parent = "/" + parent;
            }
            this.conditions.add(Condition.isChildNode(CI_SELECTOR_NAME, parent));
        }
    }

    private void createConditionForAncestor() {
        if (!Strings.nullToEmpty((String)this.parameters.getAncestor()).trim().isEmpty()) {
            String ancestor = Strings.nullToEmpty((String)this.parameters.getAncestor());
            if (!ancestor.startsWith("/")) {
                ancestor = "/" + ancestor;
            }
            this.conditions.add(Condition.isDescendantNode(CI_SELECTOR_NAME, ancestor));
        }
    }

    private void createConditionForName() {
        if (!Strings.nullToEmpty((String)this.parameters.getName()).trim().isEmpty()) {
            if (this.parameters.getName().contains("%")) {
                this.conditions.add(Condition.nameLike(CI_SELECTOR_NAME, this.parameters.getName()));
            } else {
                this.conditions.add(Condition.nameIs(CI_SELECTOR_NAME, this.parameters.getName()));
            }
        }
    }

    private void createConditionForDate() {
        if (this.parameters.getBefore() != null) {
            this.conditions.add(Condition.from(CI_SELECTOR_NAME, "$lastModified", "_before", "<=", this.parameters.getBefore()));
        }
    }

    private void createConditionsForProperties() {
        for (Map.Entry entry : this.parameters.getProperties().entrySet()) {
            this.createConditionForProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void createConditionForProperty(String propertyName, String propertyValue) {
        PropertyDescriptor propertyDescriptor;
        Descriptor descriptor;
        if (this.parameters.getType() != null && (descriptor = DescriptorRegistry.getDescriptor((Type)this.parameters.getType())) != null && (propertyDescriptor = descriptor.getPropertyDescriptor(propertyName)) != null) {
            if (propertyDescriptor.getKind() == PropertyKind.CI) {
                String selectorName = "referenced" + this.nextSelectorId;
                this.joins.append(" INNER JOIN [deployit:configurationItem] AS " + selectorName + " ON " + CI_SELECTOR_NAME + ".[" + propertyName + "] = " + selectorName + ".[jcr:uuid]");
                int lastSlash = propertyValue.lastIndexOf(47);
                Preconditions.checkArgument((lastSlash != -1 ? 1 : 0) != 0, (Object)(propertyValue + " is a ID but does not contain a slash (/)"));
                String parent = JcrPathHelper.getAbsolutePathFromId(propertyValue.substring(0, lastSlash));
                String name = propertyValue.substring(lastSlash + 1);
                this.conditions.add(Condition.isChildNode(selectorName, parent));
                this.conditions.add(Condition.nameIs(selectorName, name));
                ++this.nextSelectorId;
                return;
            }
            if (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) {
                throw new IllegalArgumentException("Cannot query property " + propertyDescriptor + " because it is of type SET_OF_CIS");
            }
        }
        this.conditions.add(Condition.match(CI_SELECTOR_NAME, propertyName, propertyName, propertyValue));
    }

    private void createConditionsForTextSearch() {
        int count = 0;
        for (Map.Entry query : this.parameters.getTextSearchQueries().entrySet()) {
            this.conditions.add(Condition.textSearch((String)query.getKey(), (String)query.getValue(), "textSearch" + count + "_"));
        }
    }

    private static class Condition {
        String selector;
        String field;
        String operator;
        String parameter;
        Object[] values;
        boolean caseInsensitive;
        private static final String NAME_IS_FORMAT = "NAME(%s) = '%s'";
        private static final String NAME_LIKE_FORMAT = "LOWER(NAME(%s)) LIKE '%s'";
        private static final String ISCHILDNODE_FORMAT = "ISCHILDNODE(%s, ['%s'])";
        private static final String ISDESCENDANTNODE_FORMAT = "ISDESCENDANTNODE(%s, ['%s'])";
        private static final String CONTAINS_FORMAT = "contains(%s.[%s], $%s)";
        private static final String CASE_SENSITIVE = "%s.[%s] %s $%s";
        private static final String CASE_INSENSITIVE = "LOWER(%s.[%s]) %s $%s";

        private Condition() {
        }

        String build() {
            StringBuilder conditionString = new StringBuilder();
            conditionString.append("(");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    conditionString.append(" OR ");
                }
                if (this.operator.equals(SearchQueryBuilder.NAME_IS_OPERATOR)) {
                    conditionString.append(String.format(NAME_IS_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.NAME_LIKE_OPERATOR)) {
                    conditionString.append(String.format(NAME_LIKE_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.ISCHILDNODE_OPERATOR)) {
                    conditionString.append(String.format(ISCHILDNODE_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.ISDESCENDANTNODE_OPERATOR)) {
                    conditionString.append(String.format(ISDESCENDANTNODE_FORMAT, this.selector, this.values[i]));
                    continue;
                }
                if (this.operator.equals(SearchQueryBuilder.CONTAINS_OPERATOR)) {
                    conditionString.append(String.format(CONTAINS_FORMAT, this.selector, this.field, this.parameter + i));
                    continue;
                }
                conditionString.append(String.format(this.caseInsensitive ? CASE_INSENSITIVE : CASE_SENSITIVE, this.selector, this.field, this.operator, this.parameter + i));
            }
            conditionString.append(")");
            return conditionString.toString();
        }

        static Condition match(String selector, String field, String parameter, String value) {
            boolean caseInsensitive;
            String operator;
            if (value.contains("%")) {
                operator = SearchQueryBuilder.LIKE_OPERATOR;
                caseInsensitive = true;
            } else {
                operator = SearchQueryBuilder.EQUALITY_OPERATOR;
                caseInsensitive = false;
            }
            return Condition.from(selector, field, parameter, operator, caseInsensitive, value);
        }

        static Condition nameIs(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.NAME_IS_OPERATOR, false, value);
        }

        static Condition nameLike(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.NAME_LIKE_OPERATOR, false, value.toLowerCase());
        }

        static Condition isChildNode(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.ISCHILDNODE_OPERATOR, false, value);
        }

        static Condition isDescendantNode(String selector, String value) {
            return Condition.from(selector, null, null, SearchQueryBuilder.ISDESCENDANTNODE_OPERATOR, false, value);
        }

        static Condition textSearch(String property, String textQuery, String parameterName) {
            return Condition.from(SearchQueryBuilder.CI_SELECTOR_NAME, property, parameterName, SearchQueryBuilder.CONTAINS_OPERATOR, false, textQuery);
        }

        static Condition from(String selector, String field, String parameter, String operator, Object value) {
            return Condition.from(selector, field, parameter, operator, false, value);
        }

        static Condition from(String selector, String field, String parameter, String operator, boolean caseInsensitive, Object ... values) {
            Condition t = new Condition();
            t.selector = selector;
            t.field = field;
            t.parameter = parameter;
            t.operator = operator;
            t.caseInsensitive = caseInsensitive;
            t.values = values;
            return t;
        }
    }
}

