/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.components.TraversalListener;
import fitnesse.responders.search.ResultResponder;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.refactoring.ContentReplacingSearchObserver;
import fitnesse.wiki.search.RegularExpressionWikiPageFinder;

public class SearchReplaceResponder
extends ResultResponder
implements TraversalListener<WikiPage> {
    private TraversalListener<? super WikiPage> contentReplaceObserver;
    private TraversalListener<? super WikiPage> webOutputObserver;

    protected String getPageFooterInfo(int hits) {
        return String.format("Replaced %d matches for your search.", hits);
    }

    @Override
    protected String getTitle() {
        return String.format("Replacing matching content \"%s\" with content \"%s\"", this.getSearchString(), this.getReplacementString());
    }

    private String getReplacementString() {
        return this.request.getInput("replacementString");
    }

    private String getSearchString() {
        return this.request.getInput("searchString");
    }

    @Override
    public void process(WikiPage page) {
        this.contentReplaceObserver.process(page);
        this.webOutputObserver.process(page);
    }

    @Override
    public void traverse(TraversalListener<Object> observer) {
        this.webOutputObserver = observer;
        String searchString = this.getSearchString();
        String replacementString = this.getReplacementString();
        this.contentReplaceObserver = new ContentReplacingSearchObserver(searchString, replacementString);
        RegularExpressionWikiPageFinder finder = new RegularExpressionWikiPageFinder(searchString, (TraversalListener<? super WikiPage>)this);
        finder.search(this.page);
    }
}

