/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.errors.SymlinksNotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.FS_POSIX_Java5;
import org.eclipse.jgit.util.FS_POSIX_Java6;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.FS_Win32_Cygwin;
import org.eclipse.jgit.util.SystemReader;

public abstract class FS {
    public static final FS DETECTED = FS.detect();
    private static FSFactory factory;
    private volatile Holder<File> userHome;
    private volatile Holder<File> gitPrefix;

    public static FS detect() {
        return FS.detect(null);
    }

    public static FS detect(Boolean cygwinUsed) {
        if (factory == null) {
            try {
                Class<?> activatorClass = Class.forName("org.eclipse.jgit.util.Java7FSFactory");
                factory = (FSFactory)activatorClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                factory = new FSFactory();
            }
            catch (UnsupportedClassVersionError e) {
                factory = new FSFactory();
            }
            catch (InstantiationException e) {
                factory = new FSFactory();
            }
            catch (IllegalAccessException e) {
                factory = new FSFactory();
            }
        }
        return factory.detect(cygwinUsed);
    }

    protected FS() {
    }

    protected FS(FS src) {
        this.userHome = src.userHome;
        this.gitPrefix = src.gitPrefix;
    }

    public abstract FS newInstance();

    public abstract boolean supportsExecute();

    public boolean supportsSymlinks() {
        return false;
    }

    public abstract boolean isCaseSensitive();

    public abstract boolean canExecute(File var1);

    public abstract boolean setExecute(File var1, boolean var2);

    public long lastModified(File f) throws IOException {
        return f.lastModified();
    }

    public void setLastModified(File f, long time) throws IOException {
        f.setLastModified(time);
    }

    public long length(File path) throws IOException {
        return path.length();
    }

    public void delete(File f) throws IOException {
        if (!f.delete()) {
            throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, f.getAbsolutePath()));
        }
    }

    public File resolve(File dir, String name) {
        File abspn = new File(name);
        if (abspn.isAbsolute()) {
            return abspn;
        }
        return new File(dir, name);
    }

    public File userHome() {
        Holder<File> p = this.userHome;
        if (p == null) {
            this.userHome = p = new Holder<File>(this.userHomeImpl());
        }
        return (File)p.value;
    }

    public FS setUserHome(File path) {
        this.userHome = new Holder<File>(path);
        return this;
    }

    public abstract boolean retryFailedLockFileCommit();

    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        if (home == null || home.length() == 0) {
            return null;
        }
        return new File(home).getAbsoluteFile();
    }

    protected static File searchPath(String path, String ... lookFor) {
        if (path == null) {
            return null;
        }
        for (String p : path.split(File.pathSeparator)) {
            for (String command : lookFor) {
                File e = new File(p, command);
                if (!e.isFile()) continue;
                return e.getAbsoluteFile();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readPipe(File dir, String[] command, String encoding) {
        boolean debug;
        block15: {
            debug = Boolean.parseBoolean(SystemReader.getInstance().getProperty("jgit.fs.debug"));
            try {
                if (debug) {
                    System.err.println("readpipe " + Arrays.asList(command) + "," + dir);
                }
                final Process p = Runtime.getRuntime().exec(command, null, dir);
                BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), encoding));
                p.getOutputStream().close();
                final AtomicBoolean gooblerFail = new AtomicBoolean(false);
                Thread gobbler = new Thread(){

                    public void run() {
                        InputStream is = p.getErrorStream();
                        try {
                            if (debug) {
                                int ch;
                                while ((ch = is.read()) != -1) {
                                    System.err.print((char)ch);
                                }
                            } else {
                                while (is.read() != -1) {
                                }
                            }
                        }
                        catch (IOException e) {
                            if (debug) {
                                e.printStackTrace(System.err);
                            }
                            gooblerFail.set(true);
                        }
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            if (debug) {
                                e.printStackTrace(System.err);
                            }
                            gooblerFail.set(true);
                        }
                    }
                };
                gobbler.start();
                String r = null;
                try {
                    String l;
                    r = lineRead.readLine();
                    if (debug) {
                        System.err.println("readpipe may return '" + r + "'");
                        System.err.println("(ignoring remaing output:");
                    }
                    while ((l = lineRead.readLine()) != null) {
                        if (!debug) continue;
                        System.err.println(l);
                    }
                }
                finally {
                    p.getErrorStream().close();
                    lineRead.close();
                }
                while (true) {
                    try {
                        int rc = p.waitFor();
                        gobbler.join();
                        if (rc == 0 && r != null && r.length() > 0 && !gooblerFail.get()) {
                            return r;
                        }
                        if (debug) {
                            System.err.println("readpipe rc=" + rc);
                        }
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (!debug) break block15;
                System.err.println(e);
            }
        }
        if (debug) {
            System.err.println("readpipe returns null");
        }
        return null;
    }

    public File gitPrefix() {
        Holder<File> p = this.gitPrefix;
        if (p == null) {
            String overrideGitPrefix = SystemReader.getInstance().getProperty("jgit.gitprefix");
            p = overrideGitPrefix != null ? new Holder<File>(new File(overrideGitPrefix)) : new Holder<File>(this.discoverGitPrefix());
            this.gitPrefix = p;
        }
        return (File)p.value;
    }

    protected abstract File discoverGitPrefix();

    public FS setGitPrefix(File path) {
        this.gitPrefix = new Holder<File>(path);
        return this;
    }

    public String readSymLink(File path) throws IOException {
        throw new SymlinksNotSupportedException(JGitText.get().errorSymlinksNotSupported);
    }

    public boolean isSymLink(File path) throws IOException {
        return false;
    }

    public boolean exists(File path) {
        return path.exists();
    }

    public boolean isDirectory(File path) {
        return path.isDirectory();
    }

    public boolean isFile(File path) {
        return path.isFile();
    }

    public boolean isHidden(File path) throws IOException {
        return path.isHidden();
    }

    public void setHidden(File path, boolean hidden) throws IOException {
        if (!path.getName().startsWith(".")) {
            throw new IllegalArgumentException("Hiding only allowed for names that start with a period");
        }
    }

    public void createSymLink(File path, String target) throws IOException {
        throw new SymlinksNotSupportedException(JGitText.get().errorSymlinksNotSupported);
    }

    public abstract ProcessBuilder runInShell(String var1, String[] var2);

    public Attributes getAttributes(File path) {
        boolean isFile;
        boolean isDirectory = this.isDirectory(path);
        boolean bl = isFile = !isDirectory && path.isFile();
        assert (path.exists() == isDirectory || isFile);
        boolean exists = isDirectory || isFile;
        boolean canExecute = exists && !isDirectory && this.canExecute(path);
        boolean isSymlink = false;
        long lastModified = exists ? path.lastModified() : 0L;
        long createTime = 0L;
        return new Attributes(this, path, exists, isDirectory, canExecute, isSymlink, isFile, createTime, lastModified, -1L);
    }

    public File normalize(File file) {
        return file;
    }

    public String normalize(String name) {
        return name;
    }

    public static class Attributes {
        private boolean isDirectory;
        private boolean isSymbolicLink;
        private boolean isRegularFile;
        private long creationTime;
        private long lastModifiedTime;
        private boolean isExecutable;
        private File file;
        private boolean exists;
        protected long length = -1L;
        FS fs;

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public boolean isExecutable() {
            return this.isExecutable;
        }

        public boolean isSymbolicLink() {
            return this.isSymbolicLink;
        }

        public boolean isRegularFile() {
            return this.isRegularFile;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        Attributes(FS fs, File file, boolean exists, boolean isDirectory, boolean isExecutable, boolean isSymbolicLink, boolean isRegularFile, long creationTime, long lastModifiedTime, long length) {
            this.fs = fs;
            this.file = file;
            this.exists = exists;
            this.isDirectory = isDirectory;
            this.isExecutable = isExecutable;
            this.isSymbolicLink = isSymbolicLink;
            this.isRegularFile = isRegularFile;
            this.creationTime = creationTime;
            this.lastModifiedTime = lastModifiedTime;
            this.length = length;
        }

        public Attributes(File path, FS fs) {
            this.file = path;
            this.fs = fs;
        }

        public long getLength() {
            if (this.length == -1L) {
                this.length = this.file.length();
                return this.length;
            }
            return this.length;
        }

        public String getName() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        boolean exists() {
            return this.exists;
        }
    }

    public static class FSFactory {
        protected FSFactory() {
        }

        public FS detect(Boolean cygwinUsed) {
            if (SystemReader.getInstance().isWindows()) {
                if (cygwinUsed == null) {
                    cygwinUsed = FS_Win32_Cygwin.isCygwin();
                }
                if (cygwinUsed.booleanValue()) {
                    return new FS_Win32_Cygwin();
                }
                return new FS_Win32();
            }
            if (FS_POSIX_Java6.hasExecute()) {
                return new FS_POSIX_Java6();
            }
            return new FS_POSIX_Java5();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Holder<V> {
        final V value;

        Holder(V value) {
            this.value = value;
        }
    }
}

