# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

import java.util.Date as Date
import java.lang.Long as Long

def has_result(events):
    result_event = [each for each in events if each.type == 'performanceResult']
    return len(result_event) > 0

run_times = []
completed_requests = []
failed_requests = []
mean_response_time = []
test_name = ''
test_specification = ''

previousRuns = testRuns.getPreviousRuns(testRun, 9)
if previousRuns:
    for prevRun in reversed(previousRuns):
        events = testRuns.getEventsForRunId(prevRun.testRunId, {'tags': tags})
        if has_result(events):
            for ev in events:
                if ev.type == 'importStarted' and test_name == '':
                    test_name = ev.get('simulationName')
                if ev.type == 'executionStarted':
                    run_times.append(Date(Long(ev.get('timestamp'))))
                if ev.type == 'performanceResult':
                    completed_requests.append(ev.get('numberOfRequests.ok'))
                    failed_requests.append(ev.get('numberOfRequests.ko'))
                    mean_response_time.append(ev.get('meanResponseTime.total'))

events = testRuns.getEventsForRunId(testRun.testRunId, {'tags': tags})
if has_result(events):
    for ev in events:
        if ev.type == 'importStarted' and test_name == '':
            test_name = ev.get('simulationName')
            if test_specification == '':
                test_specification = ev.get('testSpecification')
        if ev.type == 'executionStarted':
                run_times.append(Date(Long(ev.get('timestamp'))))
        if ev.type == 'performanceResult':
            completed_requests.append(ev.get('numberOfRequests.ok'))
            failed_requests.append(ev.get('numberOfRequests.ko'))
            mean_response_time.append(ev.get('meanResponseTime.total'))

if test_name == '' or test_name is None:
    test_name = test_specification
titleText = 'Load Test Trends - %s' %(test_name)

report_data_1 = {
    'chart': {
        'zoomType': 'xy'
    },
    'title': titleText,
    'xAxis': [{
                  'type': 'datetime',
                  'categories': run_times
              }],
    'yAxis': [{  # Secondary yAxis
                 'title': {
                     'text': 'Mean response time',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'labels': {
                     'format': '{value} ms',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'opposite': True
              },
        {  # Primary yAxis
                 'labels': {
                     'format': '{value}',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'title': {
                     'text': 'Number of Requests',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'stackLabels': {
                     'enabled': True,
                     'style': {
                         'fontWeight': 'bold',
                         'color': 'gray'
                     }
                 }
              }],
    'tooltip': {
        'shared': True
    },
    'plotOptions': {
        'column': {
            'animation': False,
            'stacking': 'normal',
            'dataLabels': {
                'enabled': True,
                'color': 'white',
                'style': {
                    'textShadow': '0 0 3px black, 0 0 3px black'
                }
            }
        }
    },
    'legend': {
        'layout': 'vertical',
        'align': 'left',
        'x': 120,
        'verticalAlign': 'top',
        'y': 0,
        'floating': True,
        'backgroundColor': '#FFFFFF'
    },
    'series': [{
                   'name': 'completed requests',
                   'type': 'column',
                   'yAxis': 1,
                   'data': completed_requests

               },
               {
                   'name': 'failed requests',
                   'type': 'column',
                   'yAxis': 1,
                   'data': failed_requests

               },
               {
                   'name': 'mean response time',
                   'type': 'spline',
                   'data': mean_response_time,
                   'animation': False,
                   'tooltip': {
                       'valueSuffix': 'ms'
                   }
               }]
}

resultHolder.setResult(report_data_1)
