<#--
 # NOTE: Please do not edit this file directly
 # Create your custom reports in the 'ext' folder
 #-->

<#macro RESULTTYPE result title>
<h3>${title}</h3>
<table class="table">
<thead>
<tr>
    <th>Level 0</th><th>Level 1</th><th>Level 2</th><th>Level 3</th><th>Team</th><th>Last Run</th><th>This Run</th>
</tr>
</thead>
<tbody>
<#assign prefix = queryParameters['prefix']!"">
<#assign depth = prefix?split(";")?size>
<#list testRuns.getResultEventsThatChangedFromLastRun(testRun) as event>
  <#assign name = event.get('name')!"" >
  <#if prefix == "">
    <#assign nameMatches = true>
  <#else>
    <#assign nameMatches = name?starts_with(prefix)>
  </#if>
  <#if event.type == 'functionalResult' && event.get('result') == result && nameMatches>
    <tr>
      <#assign level0 = "">
      <#assign level1 = "">
      <#assign level2 = "">
      <#assign level3 = "">
      <#list name?split(";") as x>
        <#if x_index == 0>
          <#assign level0 = x>
        </#if>
        <#if x_index == 1>
          <#assign level1 = x>
        </#if>
        <#if x_index == 2>
          <#assign level2 = x>
        </#if>
        <#if x_index == 3>
          <#assign level3 = x>
        </#if>
      </#list>
      <td><a href="http://localhost:8084/FrontPage.${level0}">${level0}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${level0}.${level1}">${level1}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${level0}.${level1}.${level2}">${level2}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${level0}.${level1}.${level2}.${level3}">${level3}</a></td>
      <td>
        <#if event.hasProperty('team')>
          ${event.get('team')}
        </#if>
      </td>
      <td>
      <#if event.get('result') == "PASSED">FAILED<#else>PASSED</#if>
      </td>
      <td>${event.get("result")}</td>
    </tr>
    <tr class="secondary">
      <td colspan="4">
        <#if depth &gt; 3>
          <#assign correspondingOlderEvents = testRuns.getCorrespondingEventsFromOlderRuns(testRun, event, 10, 'type', 'name')>
          <#assign thisResult = event.get('result')!"">
          <#assign prevResult = thisResult>
          <#assign nChanges = 0>
          <#assign total = 1>
          <#list correspondingOlderEvents as olderEvent>
            <#assign oldResult = olderEvent.get('result')!"">
            <#if oldResult != prevResult>
              <#assign prevResult = oldResult>
              <#assign nChanges = nChanges + 1>
            </#if>
            <#assign total = total + 1>
          </#list>

          <#assign flaky = ((nChanges / total) * 100)?floor >
          <br/>
          <table>
            <tr>
              <td><div title="Flakiness is the number of different test results over time divided by the number of test results">${flaky}% flaky</div></td>
                <#list correspondingOlderEvents as olderEvent>
                  <#assign oldResult = olderEvent.get('result')!"">
                  <#assign report_id = this.getId() >
                  <#assign run_id = olderEvent.get('runId') >
                  <#assign team = olderEvent.get('team')!"" >
                  <#assign name = olderEvent.get('name') >
                  <#assign level0 = "">
                  <#assign level1 = "">
                  <#assign level2 = "">
                  <#assign level3 = "">
                  <#list name?split(".") as x>
                    <#if x_index == 0>
                      <#assign level0 = x>
                    </#if>
                    <#if x_index == 1>
                      <#assign level1 = x>
                    </#if>
                    <#if x_index == 2>
                      <#assign level2 = x>
                    </#if>
                    <#if x_index == 3>
                      <#assign level3 = x>
                    </#if>
                  </#list>
                  <#assign runDay = this.thisDay(olderEvent.get('timestamp')) >
                  <#if oldResult == "PASSED">
                    <td bgcolor="#9ada7f">
                  <#else>
                    <td bgcolor="#fd8d10">
                  </#if>
                  <a href="#/reports/${run_id}/${report_id}?prefix=${level0}.${level1}.${level2}.${level3}">${runDay}</a>
                </td>
              </#list>
            </tr>
          </table>
        </#if>
      </td>
    </tr>
  </#if>
</#list>
</tbody>
</table>
</#macro>

<#assign events = testRun.getEvents() >
<h2>Historical comparison details table</h2>
<p>This table shows a comparison of tests that changed state (passed -> failed or visa versa).</p>
<table data-title="Historical comparison details table" class="table two-rows">
<tbody style="overflow-y: auto;">
<@RESULTTYPE result="FAILED" title="Failed"/>
<@RESULTTYPE result="PASSED" title="Passed"/>
</tbody>
</table>

