package com.xebialabs.xltest.samplejmeter;


import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.junit.Test;

import java.io.File;

public class JmeterSampleTest {

    private static final String TEST_RESOURCES = "src/test/resources/";

    @Test
    public void runsJMeterSample() throws Exception {

        //JMeter Engine
        StandardJMeterEngine jmeter = new StandardJMeterEngine();
        String pathToJmeterProperties = getPathTo("jmeter.properties");
        JMeterUtils.loadJMeterProperties(pathToJmeterProperties);
        System.out.println("path to jmeter properties --> " + pathToJmeterProperties);

        String pathToJmeterHome = "";
        System.out.println("path to jmeter home--> " + pathToJmeterHome);
        String pathTo = getPathTo(pathToJmeterHome);
        JMeterUtils.setJMeterHome(pathTo);

        JMeterUtils.setProperty("saveservice_properties", "saveservice.properties");

        JMeterUtils.initLogging();// you can comment this line out to see extra log messages of i.e. DEBUG level
        JMeterUtils.initLocale();

        // JMeter Test Plan, basic all u JOrphan HashTree
        HashTree testPlanTree = new HashTree();

        // HTTP Sampler
        HTTPSampler httpSampler = new HTTPSampler();
        httpSampler.setDomain("computer-database.herokuapp.com");
        httpSampler.setPort(80);
        httpSampler.setPath("/");
        httpSampler.setMethod("GET");

        // Loop Controller
        LoopController loopController = new LoopController();
        loopController.setLoops(10);
        loopController.addTestElement(httpSampler);
        loopController.setFirst(true);
        loopController.initialize();

        // Thread Group
        org.apache.jmeter.threads.ThreadGroup threadGroup = new ThreadGroup();
        threadGroup.setNumThreads(4);
        threadGroup.setRampUp(1);
        threadGroup.setSamplerController(loopController);

        // Test Plan
        TestPlan testPlan = new TestPlan("Create JMeter Script From Java Code");

        // Construct Test Plan from previously initialized elements
        testPlanTree.add("testPlan", testPlan);
        testPlanTree.add("loopController", loopController);
        testPlanTree.add("threadGroup", threadGroup);
        testPlanTree.add("httpSampler", httpSampler);

        Summariser summer = null;
        String summariserName = JMeterUtils.getPropDefault("summariser.name", "summary"); //$NON-NLS-1$
        if (summariserName.length() > 0) {
            summer = new Summariser(summariserName);
        }

        String logFile = new File("results") + File.separator + "results.csv";
        System.out.println("path to results --> " + logFile);
        ResultCollector logger = new ResultCollector(summer);
        logger.setFilename(logFile);
        testPlanTree.add(testPlanTree.getArray()[0], logger);

        // Run Test Plan
        jmeter.configure(testPlanTree);
        jmeter.run();

        System.out.println("Done.");
    }

    private String getPathTo(String filename) {
        String path = TEST_RESOURCES + filename;
        File file = new File(path);
        if (!file.canRead()) {
            throw new IllegalArgumentException("File  cannot be found or read from " + path);
        }
        return path;
    }
}
