/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.concurrent.TimeUnit;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;

public class RpcOptions {
    private final long timeout;
    private final TimeUnit unit;
    private final boolean fifoOrder;
    private final boolean totalOrder;
    private final ResponseFilter responseFilter;
    private final ResponseMode responseMode;
    private final boolean skipReplicationQueue;

    public RpcOptions(long timeout, TimeUnit unit, ResponseFilter responseFilter, ResponseMode responseMode, boolean skipReplicationQueue, boolean fifoOrder, boolean totalOrder) {
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null");
        }
        if (responseMode == null) {
            throw new IllegalArgumentException("ResponseMode cannot be null");
        }
        this.timeout = timeout;
        this.unit = unit;
        this.fifoOrder = fifoOrder;
        this.totalOrder = totalOrder;
        this.responseFilter = responseFilter;
        this.responseMode = responseMode;
        this.skipReplicationQueue = skipReplicationQueue;
    }

    public long timeout() {
        return this.timeout;
    }

    public TimeUnit timeUnit() {
        return this.unit;
    }

    public boolean fifoOrder() {
        return this.fifoOrder;
    }

    public boolean totalOrder() {
        return this.totalOrder;
    }

    public ResponseFilter responseFilter() {
        return this.responseFilter;
    }

    public ResponseMode responseMode() {
        return this.responseMode;
    }

    public boolean skipReplicationQueue() {
        return this.skipReplicationQueue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcOptions options = (RpcOptions)o;
        if (this.skipReplicationQueue != options.skipReplicationQueue) {
            return false;
        }
        if (this.timeout != options.timeout) {
            return false;
        }
        if (this.fifoOrder != options.fifoOrder) {
            return false;
        }
        if (this.totalOrder != options.totalOrder) {
            return false;
        }
        if (this.responseFilter != null ? !this.responseFilter.equals(options.responseFilter) : options.responseFilter != null) {
            return false;
        }
        if (this.responseMode != options.responseMode) {
            return false;
        }
        return this.unit == options.unit;
    }

    public int hashCode() {
        int result = (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + this.unit.hashCode();
        result = 31 * result + (this.fifoOrder ? 1 : 0);
        result = 31 * result + (this.totalOrder ? 1 : 0);
        result = 31 * result + (this.responseFilter != null ? this.responseFilter.hashCode() : 0);
        result = 31 * result + this.responseMode.hashCode();
        result = 31 * result + (this.skipReplicationQueue ? 1 : 0);
        return result;
    }

    public String toString() {
        return "RpcOptions{timeout=" + this.timeout + ", unit=" + (Object)((Object)this.unit) + ", fifoOrder=" + this.fifoOrder + ", totalOrder=" + this.totalOrder + ", responseFilter=" + this.responseFilter + ", responseMode=" + (Object)((Object)this.responseMode) + ", skipReplicationQueue=" + this.skipReplicationQueue + '}';
    }
}

