/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.LinkedHashMap;
import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.DelegatingAccessDeniedHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.csrf.MissingCsrfTokenException;
import org.springframework.security.web.session.InvalidSessionAccessDeniedHandler;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsrfConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<CsrfConfigurer<H>, H> {
    private CsrfTokenRepository csrfTokenRepository = new HttpSessionCsrfTokenRepository();
    private RequestMatcher requireCsrfProtectionMatcher;

    public CsrfConfigurer<H> csrfTokenRepository(CsrfTokenRepository csrfTokenRepository) {
        Assert.notNull((Object)csrfTokenRepository, (String)"csrfTokenRepository cannot be null");
        this.csrfTokenRepository = csrfTokenRepository;
        return this;
    }

    public CsrfConfigurer<H> requireCsrfProtectionMatcher(RequestMatcher requireCsrfProtectionMatcher) {
        Assert.notNull((Object)this.csrfTokenRepository, (String)"requireCsrfProtectionMatcher cannot be null");
        this.requireCsrfProtectionMatcher = requireCsrfProtectionMatcher;
        return this;
    }

    @Override
    public void configure(H http) throws Exception {
        SessionManagementConfigurer sessionConfigurer;
        LogoutConfigurer logoutConfigurer;
        AccessDeniedHandler accessDeniedHandler;
        CsrfFilter filter = new CsrfFilter(this.csrfTokenRepository);
        if (this.requireCsrfProtectionMatcher != null) {
            filter.setRequireCsrfProtectionMatcher(this.requireCsrfProtectionMatcher);
        }
        if ((accessDeniedHandler = this.createAccessDeniedHandler(http)) != null) {
            filter.setAccessDeniedHandler(accessDeniedHandler);
        }
        if ((logoutConfigurer = http.getConfigurer(LogoutConfigurer.class)) != null) {
            logoutConfigurer.addLogoutHandler((LogoutHandler)new CsrfLogoutHandler(this.csrfTokenRepository));
        }
        if ((sessionConfigurer = http.getConfigurer(SessionManagementConfigurer.class)) != null) {
            sessionConfigurer.addSessionAuthenticationStrategy((SessionAuthenticationStrategy)new CsrfAuthenticationStrategy(this.csrfTokenRepository));
        }
        filter = this.postProcess(filter);
        http.addFilter((Filter)filter);
    }

    private AccessDeniedHandler getDefaultAccessDeniedHandler(H http) {
        ExceptionHandlingConfigurer exceptionConfig = http.getConfigurer(ExceptionHandlingConfigurer.class);
        AccessDeniedHandler handler = null;
        if (exceptionConfig != null) {
            handler = exceptionConfig.getAccessDeniedHandler();
        }
        if (handler == null) {
            handler = new AccessDeniedHandlerImpl();
        }
        return handler;
    }

    private InvalidSessionStrategy getInvalidSessionStrategy(H http) {
        SessionManagementConfigurer sessionManagement = http.getConfigurer(SessionManagementConfigurer.class);
        if (sessionManagement == null) {
            return null;
        }
        return sessionManagement.getInvalidSessionStrategy();
    }

    private AccessDeniedHandler createAccessDeniedHandler(H http) {
        InvalidSessionStrategy invalidSessionStrategy = this.getInvalidSessionStrategy(http);
        AccessDeniedHandler defaultAccessDeniedHandler = this.getDefaultAccessDeniedHandler(http);
        if (invalidSessionStrategy == null) {
            return defaultAccessDeniedHandler;
        }
        InvalidSessionAccessDeniedHandler invalidSessionDeniedHandler = new InvalidSessionAccessDeniedHandler(invalidSessionStrategy);
        LinkedHashMap<Class<MissingCsrfTokenException>, InvalidSessionAccessDeniedHandler> handlers = new LinkedHashMap<Class<MissingCsrfTokenException>, InvalidSessionAccessDeniedHandler>();
        handlers.put(MissingCsrfTokenException.class, invalidSessionDeniedHandler);
        return new DelegatingAccessDeniedHandler(handlers, defaultAccessDeniedHandler);
    }
}

