/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.Parse;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

public class SemaphoreFixture
extends Fixture {
    private static final String SEMAPHORE_SUFFIX = ".semaphore";
    private static final Vector<String> semaphores = new Vector();

    @Override
    public void doTable(Parse table) {
        String[] args = this.getArgs();
        this.doActionOnSemaphore(args[1], args[0], table.at(0, 0));
        super.doTable(table);
    }

    @Override
    public void doRow(Parse row) {
        this.ignore(row);
    }

    private void doActionOnSemaphore(String action, String name, Parse infoCells) {
        boolean isOk = false;
        if ("lock".equals(action)) {
            isOk = SemaphoreFixture.lockSemaphore(name);
            if (!isOk) {
                SemaphoreFixture.setForcedAbort(true);
            }
        } else if ("unlock".equals(action)) {
            isOk = SemaphoreFixture.unlockSemaphore(name);
        } else {
            this.exception(infoCells.parts, new Throwable("Bad action: " + action));
        }
        if (isOk) {
            infoCells.parts.last().more = new Parse("td", SemaphoreFixture.makeSemaphoreName(name), null, null);
            this.right(infoCells);
        } else {
            this.exception(infoCells.parts, new Throwable("Unable to " + action + " semaphore '" + name + "'"));
        }
    }

    private static String makeSemaphoreName(String name) {
        return System.getProperty("user.dir") + "/semaphores/" + name + SEMAPHORE_SUFFIX;
    }

    public static boolean lockSemaphore(String name) {
        boolean isLocked = semaphores.contains(name);
        if (!isLocked && (isLocked = SemaphoreFixture.createSemaphore(name))) {
            semaphores.add(name);
        }
        return isLocked;
    }

    public static boolean unlockSemaphore(String name) {
        boolean isOk = false;
        if (semaphores.contains(name) && (isOk = SemaphoreFixture.deleteSemaphore(name))) {
            semaphores.remove(name);
        }
        return isOk;
    }

    private static boolean createSemaphore(String name) {
        boolean isLocked = false;
        File semDiry = new File(SemaphoreFixture.makeSemaphoreName(""));
        semDiry.mkdirs();
        File semFile = new File(SemaphoreFixture.makeSemaphoreName(name));
        try {
            isLocked = semFile.createNewFile();
        }
        catch (Exception e) {
            isLocked = false;
        }
        return isLocked;
    }

    private static boolean deleteSemaphore(String name) {
        boolean isOk = new File(SemaphoreFixture.makeSemaphoreName(name)).delete();
        if (!isOk) {
            System.out.print("Unable to remove semaphore '" + name + "'");
        }
        return isOk;
    }

    public static void ClearSemaphores() {
        Iterator<String> iter = semaphores.iterator();
        while (iter.hasNext()) {
            SemaphoreFixture.unlockSemaphore(iter.next());
        }
    }
}

