/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.FitNesseContext;
import fitnesse.junit.FitNesseRunner;
import fitnesse.junit.JavaFormatter;
import fitnesse.junit.PrintTestListener;
import fitnesse.testrunner.MultipleTestsRunner;
import fitnesse.testrunner.PagesByTestSystem;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testrunner.SuiteFilter;
import fitnesse.testsystems.ConsoleExecutionLogListener;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;

public class JUnitHelper {
    public static final String PAGE_TYPE_SUITE = "suite";
    public static final String PAGE_TYPE_TEST = "test";
    private final String outputDir;
    private final String fitNesseRootPath;
    private final TestSystemListener resultsListener;
    private int port = 0;
    private boolean debugMode = true;

    public JUnitHelper(String fitNesseRootPath, String outputPath) {
        this(fitNesseRootPath, outputPath, new PrintTestListener());
    }

    public JUnitHelper(String fitNesseDir, String outputDir, TestSystemListener resultsListener) {
        this.fitNesseRootPath = fitNesseDir;
        this.outputDir = outputDir;
        this.resultsListener = resultsListener;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDebugMode(boolean enabled) {
        this.debugMode = enabled;
    }

    public void assertTestPasses(String testName) throws Exception {
        this.assertPasses(testName, PAGE_TYPE_TEST, null);
    }

    public void assertSuitePasses(String suiteName) throws Exception {
        this.assertPasses(suiteName, PAGE_TYPE_SUITE, null);
    }

    public void assertSuitePasses(String suiteName, String suiteFilter) throws Exception {
        this.assertPasses(suiteName, PAGE_TYPE_SUITE, suiteFilter);
    }

    public void assertSuitePasses(String suiteName, String suiteFilter, String excludeSuiteFilter) throws Exception {
        this.assertPasses(suiteName, PAGE_TYPE_SUITE, suiteFilter, excludeSuiteFilter);
    }

    public void assertPasses(String pageName, String pageType, String suiteFilter) throws Exception {
        this.assertPasses(pageName, pageType, suiteFilter, null);
    }

    public void assertPasses(String pageName, String pageType, String suiteFilter, String excludeSuiteFilter) throws Exception {
        FitNesseContext context = FitNesseRunner.initContext(new File("plugins.properties"), this.fitNesseRootPath, "FitNesseRoot", this.port);
        JavaFormatter testFormatter = new JavaFormatter(pageName);
        testFormatter.setResultsRepository(new JavaFormatter.FolderResultsRepository(this.outputDir));
        MultipleTestsRunner testRunner = this.createTestRunner(this.initChildren(pageName, suiteFilter, excludeSuiteFilter, context), context);
        testRunner.addTestSystemListener(testFormatter);
        testRunner.addTestSystemListener(this.resultsListener);
        testRunner.addExecutionLogListener(new ConsoleExecutionLogListener());
        testRunner.executeTestPages();
        TestSummary summary = testFormatter.getTotalSummary();
        Assert.assertEquals("wrong", 0L, summary.getWrong());
        Assert.assertEquals("exceptions", 0L, summary.getExceptions());
        Assert.assertTrue(this.msgAtLeastOneTest(pageName, summary), summary.getRight() > 0);
    }

    private List<WikiPage> initChildren(String suiteName, String suiteFilter, String excludeSuiteFilter, FitNesseContext context) {
        WikiPage suiteRoot = this.getSuiteRootPage(suiteName, context);
        if (!suiteRoot.getData().hasAttribute("Suite")) {
            return Arrays.asList(suiteRoot);
        }
        return new SuiteContentsFinder(suiteRoot, new SuiteFilter(suiteFilter, excludeSuiteFilter), context.getRootPage()).getAllPagesToRunForThisSuite();
    }

    private WikiPage getSuiteRootPage(String suiteName, FitNesseContext context) {
        WikiPagePath path = PathParser.parse(suiteName);
        PageCrawler crawler = context.getRootPage().getPageCrawler();
        return crawler.getPage(path);
    }

    private MultipleTestsRunner createTestRunner(List<WikiPage> pages, FitNesseContext context) {
        PagesByTestSystem pagesByTestSystem = new PagesByTestSystem(pages, context.getRootPage());
        MultipleTestsRunner runner = new MultipleTestsRunner(pagesByTestSystem, context.testSystemFactory);
        runner.setRunInProcess(this.debugMode);
        return runner;
    }

    private String msgAtLeastOneTest(String pageName, TestSummary summary) {
        return MessageFormat.format("at least one test executed in {0}\n{1}", pageName, summary.toString());
    }
}

