/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.List;

public class DeletePageResponder
implements SecureResponder {
    private SimpleResponse response;
    private String qualifiedPageName;
    private WikiPagePath path;
    private FitNesseContext context;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        this.intializeResponse(request);
        if (this.shouldNotDelete()) {
            this.response.redirect(context.contextRoot, "FrontPage");
        } else {
            this.tryToDeletePage(request);
        }
        return this.response;
    }

    private void tryToDeletePage(Request request) {
        String confirmedString = request.getInput("confirmed");
        if (!"yes".equalsIgnoreCase(confirmedString)) {
            this.response.setContent(this.buildConfirmationHtml(this.context.getRootPage(), this.qualifiedPageName, this.context));
        } else {
            String nameOfPageToBeDeleted = this.path.last();
            this.path.removeNameFromEnd();
            WikiPage parentOfPageToBeDeleted = this.context.getRootPage().getPageCrawler().getPage(this.path);
            if (parentOfPageToBeDeleted != null) {
                parentOfPageToBeDeleted.removeChildPage(nameOfPageToBeDeleted);
            }
            this.redirect(this.path, this.response);
        }
    }

    private boolean shouldNotDelete() {
        return "FrontPage".equals(this.qualifiedPageName);
    }

    private void intializeResponse(Request request) {
        this.response = new SimpleResponse();
        this.qualifiedPageName = request.getResource();
        this.path = PathParser.parse(this.qualifiedPageName);
    }

    private void redirect(WikiPagePath path, SimpleResponse response) {
        String location = PathParser.render(path);
        if (location == null || location.isEmpty()) {
            response.redirect(this.context.contextRoot, "root");
        } else {
            response.redirect(this.context.contextRoot, location);
        }
    }

    private String buildConfirmationHtml(WikiPage root, String qualifiedPageName, FitNesseContext context) {
        HtmlPage html = context.pageFactory.newPage();
        String tags = "";
        WikiPagePath path = PathParser.parse(qualifiedPageName);
        PageCrawler crawler = root.getPageCrawler();
        WikiPage wikiPage = crawler.getPage(path);
        if (wikiPage != null) {
            PageData pageData = wikiPage.getData();
            tags = pageData.getAttribute("Suites");
        }
        html.setTitle("Delete Confirmation");
        html.setPageTitle(new PageTitle("Confirm Deletion", PathParser.parse(qualifiedPageName), tags));
        this.makeMainContent(html, root, qualifiedPageName);
        html.setMainTemplate("deletePage");
        return html.html();
    }

    private void makeMainContent(HtmlPage html, WikiPage root, String qualifiedPageName) {
        WikiPagePath path = PathParser.parse(qualifiedPageName);
        WikiPage pageToDelete = root.getPageCrawler().getPage(path);
        List<WikiPage> children = pageToDelete.getChildren();
        html.put("deleteSubPages", children != null && !children.isEmpty());
        html.put("pageName", qualifiedPageName);
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

