/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.ListExecutor;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.SlimStreamReader;
import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimSerializer;
import fitnesse.socketservice.SocketFactory;
import fitnesse.socketservice.SocketServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;

public class SlimServer
implements SocketServer {
    public static final String MALFORMED_INSTRUCTION = "MALFORMED_INSTRUCTION";
    public static final String NO_CLASS = "NO_CLASS";
    public static final String NO_INSTANCE = "NO_INSTANCE";
    public static final String NO_CONVERTER_FOR_ARGUMENT_NUMBER = "NO_CONVERTER_FOR_ARGUMENT_NUMBER";
    public static final String NO_CONSTRUCTOR = "NO_CONSTRUCTOR";
    public static final String NO_METHOD_IN_CLASS = "NO_METHOD_IN_CLASS";
    public static final String COULD_NOT_INVOKE_CONSTRUCTOR = "COULD_NOT_INVOKE_CONSTRUCTOR";
    public static final String EXCEPTION_TAG = "__EXCEPTION__:";
    public static final String EXCEPTION_STOP_TEST_TAG = "__EXCEPTION__:ABORT_SLIM_TEST:";
    public static final String EXCEPTION_STOP_SUITE_TAG = "__EXCEPTION__:ABORT_SLIM_SUITE:";
    private SlimStreamReader reader;
    private OutputStream writer;
    private ListExecutor executor;
    private boolean verbose;
    private SlimFactory slimFactory;

    public SlimServer(boolean verbose, SlimFactory slimFactory) {
        this.verbose = verbose;
        this.slimFactory = slimFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serve(Socket s) {
        try {
            this.tryProcessInstructions(s);
        }
        catch (Throwable e) {
            System.err.println("Error while executing SLIM instructions: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            this.slimFactory.stop();
            this.close();
        }
    }

    private void tryProcessInstructions(Socket s) throws IOException {
        this.initialize(s);
        boolean more = true;
        while (more) {
            more = this.processOneSetOfInstructions();
        }
    }

    private void initialize(Socket s) throws IOException {
        SocketFactory.printSocketInfo(s);
        this.reader = SlimStreamReader.getReader(s);
        this.writer = SlimStreamReader.getByteWriter(s);
        this.executor = this.slimFactory.getListExecutor(this.verbose);
        SlimStreamReader.sendSlimHeader(this.writer, String.format("Slim -- V0.4\n", new Object[0]));
    }

    private boolean processOneSetOfInstructions() throws IOException {
        String instructions = this.reader.getSlimMessage();
        if (instructions == null) {
            return true;
        }
        if (instructions.equalsIgnoreCase("bye")) {
            return false;
        }
        String resultString = this.executeInstructions(instructions);
        SlimStreamReader.sendSlimMessage(this.writer, resultString);
        return true;
    }

    private String executeInstructions(String instructions) {
        List<Object> statements = SlimDeserializer.deserialize(instructions);
        List<Object> results = this.executor.execute(statements);
        String resultString = SlimSerializer.serialize(results);
        return resultString;
    }

    private void close() {
        try {
            this.reader.close();
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

