/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.parser.ContentsItemBuilder;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;

public class Contents
extends SymbolType
implements Rule,
Translation {
    public static final String FILTER_TOC = "FILTER_TOC";
    public static final String HELP_TOC = "HELP_TOC";
    public static final String MORE_SUFFIX_DEFAULT = " ...";
    public static final String MORE_SUFFIX_TOC = "MORE_SUFFIX_TOC";
    public static final String PROPERTY_TOC = "PROPERTY_TOC";
    public static final String PROPERTY_CHARACTERS = "PROPERTY_CHARACTERS";
    public static final String PROPERTY_CHARACTERS_DEFAULT = "*+@>-";
    public static final String REGRACE_TOC = "REGRACE_TOC";

    public Contents() {
        super("Contents");
        this.wikiMatcher(new Matcher().startLineOrCell().string("!contents"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol body = parser.parseToEnd(SymbolType.Newline);
        for (Symbol option : body.getChildren()) {
            if (option.isType(SymbolType.Whitespace)) continue;
            if (!option.getContent().startsWith("-")) {
                return Symbol.nothing;
            }
            current.add(option);
        }
        current.evaluateVariables(new String[]{HELP_TOC, REGRACE_TOC, PROPERTY_TOC, FILTER_TOC, MORE_SUFFIX_TOC, PROPERTY_CHARACTERS}, parser.getVariableSource());
        return new Maybe<Symbol>(current);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        ContentsItemBuilder itemBuilder = new ContentsItemBuilder(symbol, 1, translator.getPage());
        HtmlTag contentsDiv = HtmlUtil.makeDivTag("contents");
        contentsDiv.add(HtmlUtil.makeBold("Contents:"));
        contentsDiv.add(itemBuilder.buildLevel(translator.getPage()));
        return contentsDiv.html();
    }
}

