/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.ParseSpecification;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Scanner;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.TextMaker;
import fitnesse.wikitext.parser.VariableSource;
import java.util.ArrayList;
import java.util.List;

public class Parser {
    private static final ArrayList<Symbol> emptySymbols = new ArrayList();
    private ParsingPage currentPage;
    private Scanner scanner;
    private Parser parent;
    private ParseSpecification specification;

    public static Parser make(ParsingPage currentPage, String input) {
        return Parser.make(currentPage, input, SymbolProvider.wikiParsingProvider);
    }

    public static Parser make(ParsingPage currentPage, String input, SymbolProvider provider) {
        ParseSpecification specification = new ParseSpecification().provider(provider);
        return new Parser(null, currentPage, new Scanner(new TextMaker(currentPage, currentPage.getNamedPage()), input), specification);
    }

    public Parser(Parser parent, ParsingPage currentPage, Scanner scanner, ParseSpecification specification) {
        this.parent = parent;
        this.currentPage = currentPage;
        this.scanner = scanner;
        this.specification = specification;
    }

    public ParsingPage getPage() {
        return this.currentPage;
    }

    public VariableSource getVariableSource() {
        return this.currentPage;
    }

    public Symbol getCurrent() {
        return this.scanner.getCurrent();
    }

    public int getOffset() {
        return this.scanner.getOffset();
    }

    public boolean atEnd() {
        return this.scanner.isEnd();
    }

    public boolean isMoveNext(SymbolType type) {
        return this.moveNext(1).isType(type);
    }

    public boolean endsOn(SymbolType type) {
        return this.specification.endsOn(type);
    }

    public Symbol moveNext(int count) {
        for (int i = 0; i < count; ++i) {
            this.scanner.moveNextIgnoreFirst(this.specification);
        }
        return this.scanner.getCurrent();
    }

    public List<Symbol> moveNext(SymbolType[] symbolTypes) {
        ArrayList<Symbol> tokens = new ArrayList<Symbol>();
        for (SymbolType type : symbolTypes) {
            Symbol current = this.moveNext(1);
            if (!current.isType(type)) {
                return new ArrayList<Symbol>();
            }
            tokens.add(current);
        }
        return tokens;
    }

    public Symbol peek() {
        return this.peek(1).get(0);
    }

    public List<Symbol> peek(int size) {
        return this.scanner.peek(size, new ParseSpecification().provider(this.specification));
    }

    public List<Symbol> peek(SymbolType[] types) {
        List<Symbol> lookAhead = this.scanner.peek(types.length, new ParseSpecification().provider(this.specification));
        if (lookAhead.size() != types.length) {
            return emptySymbols;
        }
        for (int i = 0; i < lookAhead.size(); ++i) {
            if (lookAhead.get(i).isType(types[i])) continue;
            return emptySymbols;
        }
        return lookAhead;
    }

    public Maybe<String> parseToAsString(SymbolType terminator) {
        int start = this.scanner.getOffset();
        this.scanner.markStart();
        this.parseTo(terminator);
        if (this.atEnd() || !this.getCurrent().isType(terminator)) {
            return Maybe.noString;
        }
        return this.scanner.stringFromStart(start);
    }

    public String parseLiteral(SymbolType terminator) {
        return this.scanner.makeLiteral(terminator).getContent();
    }

    public Symbol parse(String input) {
        return this.parseWithParent(input, this);
    }

    public Symbol parseWithParent(String input, Parser parent) {
        return new Parser(parent, this.currentPage, new Scanner(new TextMaker(this.currentPage, this.currentPage.getNamedPage()), input), new ParseSpecification().provider(this.specification)).parse();
    }

    public Symbol parseToIgnoreFirst(SymbolType type) {
        return this.parseToIgnoreFirst(new SymbolType[]{type});
    }

    public Symbol parseToIgnoreFirst(SymbolType[] types) {
        ParseSpecification newSpecification = new ParseSpecification().provider(this.specification);
        for (SymbolType symbolType : types) {
            newSpecification.terminator(symbolType);
            newSpecification.ignoreFirst(symbolType);
        }
        return this.parse(newSpecification);
    }

    public Symbol parseToIgnoreFirstWithSymbols(SymbolType ignore, SymbolProvider provider) {
        return this.parse(new ParseSpecification().ignoreFirst(ignore).terminator(ignore).provider(provider));
    }

    public Symbol parseTo(SymbolType terminator) {
        return this.parseTo(terminator, 0);
    }

    public Symbol parseTo(SymbolType terminator, int priority) {
        return this.parse(new ParseSpecification().terminator(terminator).priority(priority));
    }

    public Symbol parseToWithSymbols(SymbolType terminator, SymbolProvider provider, int priority) {
        SymbolType[] terminators = new SymbolType[]{terminator};
        return this.parseToWithSymbols(terminators, provider, priority);
    }

    public Symbol parseToWithSymbols(SymbolType[] terminators, SymbolProvider provider, int priority) {
        ParseSpecification newSpecification = new ParseSpecification().provider(provider).priority(priority);
        for (SymbolType terminator : terminators) {
            newSpecification.terminator(terminator);
        }
        return this.parse(newSpecification);
    }

    public Symbol parseToEnd(SymbolType end) {
        return this.parse(new ParseSpecification().provider(this.specification).end(end));
    }

    public Symbol parseToEnds(int priority, SymbolProvider provider, SymbolType[] moreEnds) {
        ParseSpecification newSpecification = this.specification.makeSpecification(provider, moreEnds).priority(priority);
        for (SymbolType end : moreEnds) {
            newSpecification.end(end);
        }
        return this.parse(newSpecification);
    }

    private Symbol parse(ParseSpecification newSpecification) {
        return new Parser(this, this.currentPage, this.scanner, newSpecification).parse();
    }

    public Symbol parse() {
        return this.specification.parse(this, this.scanner);
    }

    public boolean parentOwns(SymbolType current, ParseSpecification specification) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.specification.owns(current, specification)) {
            return true;
        }
        return this.parent.parentOwns(current, specification);
    }
}

