/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;

public class SymbolMatch {
    public static final SymbolMatch noMatch = new SymbolMatch();
    private final Symbol symbol;
    private final int matchLength;

    public SymbolMatch(Symbol token, int matchLength) {
        this.symbol = token;
        this.matchLength = matchLength;
    }

    public SymbolMatch(SymbolType symbolType, ScanString input, int matchLength) {
        this.symbol = new Symbol(symbolType, input.substring(0, matchLength));
        this.matchLength = matchLength;
    }

    public SymbolMatch(SymbolType symbolType, String text) {
        this.symbol = new Symbol(symbolType, text);
        this.matchLength = text.length();
    }

    private SymbolMatch() {
        this.symbol = null;
        this.matchLength = -1;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public int getMatchLength() {
        return this.matchLength;
    }

    public boolean isMatch() {
        return this.symbol != null;
    }
}

