/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.HtmlWriter;
import fitnesse.wikitext.parser.Literal;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;

public class Table
extends SymbolType
implements Rule,
Translation {
    public static final Table symbolType = new Table();

    public Table() {
        super("Table");
        this.wikiMatcher(new Matcher().startLine().string("|"));
        this.wikiMatcher(new Matcher().startLine().string("!|"));
        this.wikiMatcher(new Matcher().startLine().string("-|"));
        this.wikiMatcher(new Matcher().startLine().string("-!|"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        String content = current.getContent();
        if (content.charAt(0) == '-') {
            current.putProperty("hideFirst", "");
        }
        boolean endOfTable = false;
        while (!endOfTable) {
            Symbol row = new Symbol(SymbolType.SymbolList);
            current.add(row);
            do {
                int offset = parser.getOffset();
                Symbol cell = this.parseCell(parser, content);
                if (parser.getOffset() == offset) {
                    endOfTable = true;
                    break;
                }
                if (parser.atEnd()) {
                    return Symbol.nothing;
                }
                if (this.containsNewLine(cell)) {
                    return Symbol.nothing;
                }
                row.add(cell);
            } while (!this.endsRow(parser.getCurrent()));
            if (this.startsRow(parser.getCurrent())) continue;
            break;
        }
        return new Maybe<Symbol>(current);
    }

    private Symbol parseCell(Parser parser, String content) {
        return content.contains("!") ? parser.parseToWithSymbols(SymbolType.EndCell, SymbolProvider.literalTableProvider, 1) : parser.parseToWithSymbols(SymbolType.EndCell, SymbolProvider.tableParsingProvider, 1);
    }

    private boolean containsNewLine(Symbol cell) {
        for (Symbol child : cell.getChildren()) {
            if (!child.isType(SymbolType.Newline)) continue;
            return true;
        }
        return false;
    }

    private boolean endsRow(Symbol symbol) {
        return symbol.getContent().indexOf("\n") > 0;
    }

    private boolean startsRow(Symbol symbol) {
        return symbol.getContent().contains("\n|");
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        HtmlWriter writer = new HtmlWriter();
        writer.startTag("table");
        if (symbol.hasProperty("class")) {
            writer.putAttribute("class", symbol.getProperty("class"));
        }
        int longestRow = this.longestRow(symbol);
        int rowCount = 0;
        for (Symbol child : symbol.getChildren()) {
            writer.startTag("tr");
            if (++rowCount == 1 && symbol.hasProperty("hideFirst")) {
                writer.putAttribute("class", "hidden");
            }
            int extraColumnSpan = longestRow - this.rowLength(child);
            int column = 1;
            for (Symbol grandChild : child.getChildren()) {
                String body = this.translateCellBody(translator, grandChild);
                writer.startTag("td");
                if (extraColumnSpan > 0 && column == this.rowLength(child)) {
                    writer.putAttribute("colspan", Integer.toString(extraColumnSpan + 1));
                }
                writer.putText(body);
                writer.endTag();
                ++column;
            }
            writer.endTag();
        }
        writer.endTag();
        return writer.toHtml();
    }

    protected String translateCellBody(Translator translator, Symbol cell) {
        final String literalDelimiter = new String(new char[]{'\u00ff', '\u0001', '\u00ff'});
        cell.walkPreOrder(new SymbolTreeWalker(){

            @Override
            public boolean visit(Symbol node) {
                if (node.isType(Literal.symbolType)) {
                    node.setContent(literalDelimiter + node.getContent() + literalDelimiter);
                }
                return true;
            }

            @Override
            public boolean visitChildren(Symbol node) {
                return true;
            }
        });
        return translator.translate(cell).trim().replace(literalDelimiter, "");
    }

    protected int longestRow(Symbol table) {
        int longest = 0;
        for (Symbol row : table.getChildren()) {
            int length = this.rowLength(row);
            if (length <= longest) continue;
            longest = length;
        }
        return longest;
    }

    protected int rowLength(Symbol row) {
        return row.getChildren().size();
    }
}

