/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.ParseSpecification;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.parser.WikiWord;
import java.util.regex.Pattern;

public class TextMaker {
    public static final String eMailPattern = "[\\w-_.]+@[\\w-_.]+\\.[\\w-_.]+";
    private VariableSource variableSource;
    private SourcePage sourcePage;

    public TextMaker(VariableSource variableSource, SourcePage sourcePage) {
        this.variableSource = variableSource;
        this.sourcePage = sourcePage;
    }

    public SymbolMatch make(ParseSpecification specification, String text) {
        int length;
        if (specification.matchesFor(WikiWord.symbolType) && (length = this.findWikiWordLength(text)) > 0) {
            Symbol wikiWord = new Symbol(new WikiWord(this.sourcePage), text.substring(0, length));
            wikiWord.evaluateVariables(new String[]{"REGRACE_LINK"}, this.variableSource);
            return new SymbolMatch(wikiWord, length);
        }
        if (specification.matchesFor(SymbolType.EMail) && this.isEmailAddress(text)) {
            return new SymbolMatch(SymbolType.EMail, text);
        }
        return new SymbolMatch(SymbolType.Text, text);
    }

    private boolean isEmailAddress(String text) {
        return text.indexOf("@") > 0 && Pattern.matches(eMailPattern, text);
    }

    public int findWikiWordLength(String text) {
        int offset;
        String candidate = text + ".";
        int n = offset = "<>^.".contains(candidate.substring(0, 1)) ? 1 : 0;
        while (offset < candidate.length()) {
            int dot = candidate.indexOf(".", offset);
            int word = this.wikiWordLength(candidate.substring(offset, dot));
            if (word == 0) {
                return offset > 1 ? offset - 1 : 0;
            }
            if (offset + word < dot) {
                return offset + word;
            }
            offset = dot + 1;
        }
        return text.length();
    }

    private int wikiWordLength(String candidate) {
        int i;
        if (candidate.length() < 3) {
            return 0;
        }
        if (!this.isUpperCaseLetter(candidate, 0)) {
            return 0;
        }
        if (!this.isDigit(candidate, 1) && !this.isLowerCaseLetter(candidate, 1)) {
            return 0;
        }
        int lastUpperCaseLetter = 0;
        for (i = 2; i < candidate.length(); ++i) {
            if (this.isCharacter(candidate, '_', i)) {
                return 0;
            }
            if (this.isUpperCaseLetter(candidate, i)) {
                if (i == lastUpperCaseLetter + 1) {
                    return 0;
                }
                lastUpperCaseLetter = i;
                continue;
            }
            if (!this.isDigit(candidate, i) && !this.isLetter(candidate, i)) break;
        }
        if (lastUpperCaseLetter > 0 && i > 2) {
            return i;
        }
        return 0;
    }

    private boolean isUpperCaseLetter(String candidate, int offset) {
        return candidate.charAt(offset) >= 'A' && candidate.charAt(offset) <= 'Z';
    }

    private boolean isLowerCaseLetter(String candidate, int offset) {
        return candidate.charAt(offset) >= 'a' && candidate.charAt(offset) <= 'z';
    }

    private boolean isDigit(String candidate, int offset) {
        return candidate.charAt(offset) >= '0' && candidate.charAt(offset) <= '9';
    }

    private boolean isLetter(String candidate, int offset) {
        return this.isUpperCaseLetter(candidate, offset) || this.isLowerCaseLetter(candidate, offset);
    }

    private boolean isCharacter(String candidate, char character, int offset) {
        return candidate.charAt(offset) == character;
    }
}

