/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleWireImpl;
import org.knopflerfish.framework.Util;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleCapabilityImpl
implements BundleCapability {
    private final BundleGeneration gen;
    private final BundleGeneration owner;
    private final String nameSpace;
    private final Map<String, Object> attributes;
    private final Map<String, String> directives;
    private Vector<BundleWireImpl> wires = new Vector(2);

    public BundleCapabilityImpl(BundleGeneration gen, Util.HeaderEntry he) {
        this.gen = gen;
        this.owner = gen;
        this.nameSpace = he.getKey();
        for (String ns : Arrays.asList("osgi.wiring.bundle", "osgi.wiring.host", "osgi.wiring.package", "osgi.identity")) {
            if (!ns.equals(this.nameSpace)) continue;
            throw new IllegalArgumentException(((Object)new StringBuffer().append("Capability with name-space '").append(ns).append("' must not be provided in the ").append("Provide-Capability").append(" manifest header.")).toString());
        }
        this.attributes = Collections.unmodifiableMap(he.getAttributes());
        this.directives = Collections.unmodifiableMap(he.getDirectives());
    }

    public BundleCapabilityImpl(BundleCapability bc, BundleGeneration bg) {
        this.gen = bg;
        this.owner = ((BundleCapabilityImpl)bc).owner;
        this.nameSpace = bc.getNamespace();
        this.attributes = bc.getAttributes();
        this.directives = bc.getDirectives();
    }

    public BundleCapabilityImpl(BundleGeneration bg) {
        this.owner = this.gen = bg;
        this.nameSpace = "osgi.identity";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("osgi.identity", this.gen.symbolicName);
        attrs.put("type", this.gen.fragment != null ? "osgi.fragment" : "osgi.bundle");
        attrs.put("version", this.gen.version);
        if (this.gen.archive != null) {
            String a = this.gen.archive.getAttribute("Bundle-Copyright");
            if (a != null) {
                attrs.put("copyright", a);
            }
            if ((a = this.gen.archive.getAttribute("Bundle-Description")) != null) {
                attrs.put("description", a);
            }
            if ((a = this.gen.archive.getAttribute("Bundle-DocURL")) != null) {
                attrs.put("documentation", a);
            }
            if ((a = this.gen.archive.getAttribute("Bundle-License")) != null) {
                StringBuffer sb = new StringBuffer();
                try {
                    List<Util.HeaderEntry> lic = Util.parseManifestHeader("Bundle-License", a, true, true, false);
                    for (Util.HeaderEntry he : lic) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(he.getKey());
                    }
                }
                catch (IllegalArgumentException iae) {
                    this.gen.bundle.fwCtx.frameworkInfo(this.gen.bundle, iae, new FrameworkListener[0]);
                    sb.append(a);
                }
                attrs.put("license", ((Object)sb).toString());
            }
        }
        this.attributes = Collections.unmodifiableMap(attrs);
        HashMap<String, String> dirs = new HashMap<String, String>();
        dirs.put("singleton", this.gen.singleton ? "true" : "false");
        this.directives = Collections.unmodifiableMap(dirs);
    }

    @Override
    public String getNamespace() {
        return this.nameSpace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public BundleRevision getRevision() {
        return this.owner.bundleRevision;
    }

    @Override
    public BundleRevision getResource() {
        return this.owner.bundleRevision;
    }

    public String toString() {
        return ((Object)new StringBuffer().append("BundleCapability[nameSpace=").append(this.nameSpace).append(", attributes=").append(this.attributes).append(", directives=").append(this.directives).append(", revision=").append(this.getRevision()).append("]")).toString();
    }

    BundleGeneration getBundleGeneration() {
        return this.gen;
    }

    boolean isEffectiveResolve() {
        String effective = this.directives.get("effective");
        return effective == null || effective.equals("resolve");
    }

    boolean isZombie() {
        return !this.gen.isCurrent();
    }

    void addWire(BundleWireImpl bw) {
        this.wires.add(bw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getWires(List<BundleWireImpl> res) {
        Vector<BundleWireImpl> vector = this.wires;
        synchronized (vector) {
            res.addAll(this.wires);
        }
    }

    void removeWire(BundleWireImpl wire) {
        this.wires.remove(wire);
    }

    void removeWires() {
        this.wires.clear();
    }

    boolean isWired() {
        return !this.wires.isEmpty();
    }

    boolean checkPermission() {
        return this.gen.bundle.fwCtx.perm.hasProvidePermission(this);
    }

    Set<String> getUses() {
        try {
            return Util.parseEnumeration("uses", this.directives.get("uses"));
        }
        catch (IllegalArgumentException iae) {
            BundleImpl b = this.gen.bundle;
            b.fwCtx.frameworkError(b, (Throwable)iae, new FrameworkListener[0]);
            return null;
        }
    }

    @Override
    public /* synthetic */ Resource getResource() {
        return this.getResource();
    }
}

