/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleContextImpl
implements BundleContext {
    final BundleImpl bundle;
    private boolean valid = true;

    public BundleContextImpl(BundleImpl bundle) {
        this.bundle = bundle;
    }

    @Override
    public String getProperty(String key) {
        this.checkValid();
        return this.bundle.fwCtx.props.getProperty(key);
    }

    @Override
    public Bundle installBundle(String location) throws BundleException {
        this.checkValid();
        return this.bundle.fwCtx.bundles.install(location, null, this.bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle installBundle(String location, InputStream in) throws BundleException {
        try {
            this.checkValid();
            BundleImpl bundleImpl = this.bundle.fwCtx.bundles.install(location, in, this.bundle);
            return bundleImpl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public Bundle getBundle() {
        this.checkValid();
        return this.bundle;
    }

    @Override
    public Bundle getBundle(long id) {
        return this.bundle.fwCtx.bundleHooks.filterBundle(this, this.bundle.fwCtx.bundles.getBundle(id));
    }

    @Override
    public Bundle[] getBundles() {
        List<Bundle> bl = this.bundle.fwCtx.bundles.getBundles();
        this.bundle.fwCtx.bundleHooks.filterBundles(this, bl);
        return bl.toArray(new Bundle[bl.size()]);
    }

    @Override
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValid();
        this.bundle.fwCtx.listeners.addServiceListener(this, listener, filter);
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        this.checkValid();
        try {
            this.bundle.fwCtx.listeners.addServiceListener(this, listener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    @Override
    public void removeServiceListener(ServiceListener listener) {
        this.checkValid();
        this.bundle.fwCtx.listeners.removeServiceListener(this, listener);
    }

    @Override
    public void addBundleListener(BundleListener listener) {
        this.checkValid();
        this.bundle.fwCtx.listeners.addBundleListener(this, listener);
    }

    @Override
    public void removeBundleListener(BundleListener listener) {
        this.checkValid();
        this.bundle.fwCtx.listeners.removeBundleListener(this, listener);
    }

    @Override
    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        this.bundle.fwCtx.listeners.addFrameworkListener(this, listener);
    }

    @Override
    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        this.bundle.fwCtx.listeners.removeFrameworkListener(this, listener);
    }

    @Override
    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        this.checkValid();
        String[] classes = (String[])clazzes.clone();
        return this.bundle.fwCtx.services.register(this.bundle, classes, service, properties);
    }

    @Override
    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        this.checkValid();
        String[] classes = new String[]{clazz};
        return this.bundle.fwCtx.services.register(this.bundle, classes, service, properties);
    }

    @Override
    public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.bundle.fwCtx.services.get(clazz, filter, this.bundle);
    }

    @Override
    public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.bundle.fwCtx.services.get(clazz, filter, null);
    }

    @Override
    public ServiceReference<?> getServiceReference(String clazz) {
        this.checkValid();
        return this.bundle.fwCtx.services.get(this.bundle, clazz);
    }

    @Override
    public <S> S getService(ServiceReference<S> reference) {
        this.checkValid();
        if (reference == null) {
            throw new NullPointerException("null ServiceReference is not valid input to getService()");
        }
        ServiceReferenceImpl sri = (ServiceReferenceImpl)reference;
        return sri.getService(this.bundle);
    }

    @Override
    public boolean ungetService(ServiceReference<?> reference) {
        this.checkValid();
        if (reference == null) {
            throw new NullPointerException("null ServiceReference is not valid input to ungetService()");
        }
        return ((ServiceReferenceImpl)reference).ungetService(this.bundle);
    }

    @Override
    public File getDataFile(String filename) {
        this.checkValid();
        File dataRoot = this.bundle.getDataRoot();
        if (dataRoot != null) {
            if (!dataRoot.exists()) {
                dataRoot.mkdirs();
            }
            return new File(dataRoot, filename);
        }
        return null;
    }

    @Override
    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValid();
        return FrameworkUtil.createFilter(filter);
    }

    @Override
    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        ServiceRegistration<?> res = this.registerService(clazz == null ? null : clazz.getName(), service, properties);
        return res;
    }

    @Override
    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        ServiceReference<?> res = this.getServiceReference(clazz == null ? null : clazz.getName());
        return res;
    }

    @Override
    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        ServiceReference<?>[] srs = this.getServiceReferences(clazz == null ? null : clazz.getName(), filter);
        if (srs == null) {
            List res = Collections.EMPTY_LIST;
            return res;
        }
        return Arrays.asList(srs);
    }

    @Override
    public Bundle getBundle(String location) {
        return this.bundle.fwCtx.bundles.getBundle(location);
    }

    void invalidate() {
        this.valid = false;
    }

    boolean isValid() {
        return this.valid;
    }

    private void checkValid() {
        if (!this.valid) {
            throw new IllegalStateException("This bundle context is no longer valid");
        }
    }
}

